/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class SelectCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = Logger.getLogger(SelectCustomFieldIndexer.class);
    private final CustomField customField;

    public SelectCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, Assertions.notNull("customField", customField));
        this.customField = customField;
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    public void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        try {
            Object value = this.customField.getValue(issue);
            if (value == null) {
                return;
            }
            if (value instanceof String || value instanceof Option) {
                String indexValue = CaseFolding.foldString(value.toString());
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), indexValue, Field.Store.YES, indexType));
                doc.add((Fieldable)new Field(this.getDocumentFieldId() + "_raw", value.toString(), Field.Store.YES, indexType));
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Invalid custom field option");
        }
    }
}

