/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class ResolutionIndexer
extends BaseFieldIndexer {
    public ResolutionIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    @Override
    public String getId() {
        return SystemSearchConstants.forResolution().getFieldId();
    }

    @Override
    public String getDocumentFieldId() {
        return SystemSearchConstants.forResolution().getIndexField();
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        if (issue.getResolutionObject() != null) {
            this.indexKeyword(doc, this.getDocumentFieldId(), issue.getResolutionObject().getId(), issue);
        } else {
            this.indexKeyword(doc, this.getDocumentFieldId(), "-1", issue);
        }
    }
}

