/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class ProjectIdIndexer
extends BaseFieldIndexer {
    public ProjectIdIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    @Override
    public String getId() {
        return SystemSearchConstants.forProject().getFieldId();
    }

    @Override
    public String getDocumentFieldId() {
        return SystemSearchConstants.forProject().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return true;
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        if (issue.getProjectObject() != null) {
            this.indexKeyword(doc, this.getDocumentFieldId(), String.valueOf(issue.getProjectObject().getId()), issue);
        }
    }
}

