/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class OriginalEstimateIndexer
extends BaseFieldIndexer {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ApplicationProperties applicationProperties;

    public OriginalEstimateIndexer(FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties) {
        super(fieldVisibilityManager);
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.fieldVisibilityManager.isFieldVisible("timetracking", issue);
    }

    @Override
    public String getId() {
        return SystemSearchConstants.forOriginalEstimate().getFieldId();
    }

    @Override
    public String getDocumentFieldId() {
        return SystemSearchConstants.forOriginalEstimate().getIndexField();
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        this.indexLongAsPaddedKeywordWithDefault(doc, this.getDocumentFieldId(), issue.getOriginalEstimate(), "-1", issue);
    }
}

