/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.GroupConverter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class GroupCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;
    private final GroupConverter groupConverter;

    public GroupCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, GroupConverter groupConverter) {
        super(fieldVisibilityManager, Assertions.notNull("customField", customField));
        this.groupConverter = groupConverter;
        this.customField = customField;
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        Object value = this.customField.getValue(issue);
        if (value != null) {
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), CaseFolding.foldUsername(this.groupConverter.getString((Group)value)), Field.Store.YES, indexType));
        }
    }
}

