/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class DueDateIndexer
extends BaseFieldIndexer {
    public DueDateIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    @Override
    public String getId() {
        return SystemSearchConstants.forDueDate().getFieldId();
    }

    @Override
    public String getDocumentFieldId() {
        return SystemSearchConstants.forDueDate().getIndexField();
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        LocalDate localDate = LocalDateFactory.from(issue.getDueDate());
        this.indexLocalDateField(doc, this.getDocumentFieldId(), localDate, issue);
    }
}

