/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultConfiguration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Indexes;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.store.Directory;

public interface IndexDirectoryFactory
extends Supplier<Map<Name, Index.Manager>> {
    public String getIndexRootPath();

    public List<String> getIndexPaths();

    public void setIndexingMode(@NotNull Mode var1);

    public static class IndexPathAdapter
    implements IndexDirectoryFactory {
        private final IndexPathManager indexPathManager;
        private final IndexWriterConfiguration writerConfiguration;
        private volatile Mode strategy = Mode.QUEUED;

        public IndexPathAdapter(@NotNull IndexPathManager indexPathManager, IndexWriterConfiguration writerConfiguration) {
            this.indexPathManager = Assertions.notNull("indexPathManager", indexPathManager);
            this.writerConfiguration = Assertions.notNull("writerConfiguration", writerConfiguration);
        }

        @Override
        public Map<Name, Index.Manager> get() {
            Mode strategy = this.strategy;
            EnumMap<Name, Index.Manager> indexes = new EnumMap<Name, Index.Manager>(Name.class);
            for (Name type : Name.values()) {
                indexes.put(type, strategy.createIndexManager(type.name(), new DefaultConfiguration(type.directory(this.indexPathManager), IssueIndexer.Analyzers.INDEXING, this.writerConfiguration)));
            }
            return Collections.unmodifiableMap(indexes);
        }

        @Override
        public String getIndexRootPath() {
            return this.indexPathManager.getIndexRootPath();
        }

        @Override
        public List<String> getIndexPaths() {
            ArrayList<String> result = new ArrayList<String>(Name.values().length);
            for (Name indexType : Name.values()) {
                try {
                    result.add(indexType.getPath(this.indexPathManager));
                }
                catch (RuntimeException ignore) {
                    // empty catch block
                }
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public void setIndexingMode(Mode strategy) {
            this.strategy = strategy;
        }
    }

    public static enum Name {
        COMMENT{

            @Override
            @NotNull
            String getPath(IndexPathManager indexPathManager) {
                return this.verify(indexPathManager, indexPathManager.getCommentIndexPath());
            }
        }
        ,
        ISSUE{

            @Override
            @NotNull
            String getPath(IndexPathManager indexPathManager) {
                return this.verify(indexPathManager, indexPathManager.getIssueIndexPath());
            }
        }
        ,
        CHANGE_HISTORY{

            @Override
            @NotNull
            String getPath(IndexPathManager indexPathManager) {
                return this.verify(indexPathManager, indexPathManager.getChangeHistoryIndexPath());
            }
        };


        @NotNull
        final Directory directory(@NotNull IndexPathManager indexPathManager) {
            LuceneDirectoryUtils luceneDirectoryUtils = ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
            return luceneDirectoryUtils.getDirectory(new File(this.getPath(indexPathManager)));
        }

        @NotNull
        final String verify(IndexPathManager indexPathManager, String path) throws IllegalStateException {
            if (indexPathManager.getMode() == IndexPathManager.Mode.DISABLED) {
                throw new IllegalStateException("Indexing is disabled.");
            }
            return Assertions.notNull("Index path is null: " + (Object)((Object)this), path);
        }

        @NotNull
        abstract String getPath(@NotNull IndexPathManager var1);
    }

    public static enum Mode {
        DIRECT{

            @Override
            Index.Manager createIndexManager(String name, Configuration configuration) {
                return Indexes.createSimpleIndexManager(configuration);
            }
        }
        ,
        QUEUED{

            @Override
            Index.Manager createIndexManager(String name, Configuration configuration) {
                return Indexes.createQueuedIndexManager(name, configuration);
            }
        };


        abstract Index.Manager createIndexManager(String var1, Configuration var2);
    }
}

