/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryFieldConstants;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.JqlChangeItemMapping;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.IndexedChangeHistoryField;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DefaultChangeHistoryRetriever
implements DefaultIssueIndexer.ChangeHistoryRetriever {
    private final ChangeHistoryManager changeManager;
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;
    private final ChangeHistoryFieldConstants changeHistoryConstants;
    private static final Map<String, String> mappings = ImmutableMap.of((Object)"Fix Version", (Object)"fixversion");
    private final JqlChangeItemMapping jqlChangeItemMapping;

    public DefaultChangeHistoryRetriever(@NotNull ChangeHistoryManager changeManager, @NotNull IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager, @NotNull ChangeHistoryFieldConstants changeHistoryConstants, @NotNull JqlChangeItemMapping jqlChangeItemMapping) {
        this.changeManager = Assertions.notNull("changeManager", changeManager);
        this.indexedChangeHistoryFieldManager = Assertions.notNull("indexedChangeHistoryFieldManager", indexedChangeHistoryFieldManager);
        this.changeHistoryConstants = Assertions.notNull("changeHistoryConstants", changeHistoryConstants);
        this.jqlChangeItemMapping = jqlChangeItemMapping;
    }

    @Override
    public List<ChangeHistoryGroup> get(Issue issue) {
        List<ChangeHistoryItem> changeHistoryItems = this.changeManager.getAllChangeItems(issue);
        return this.createChangeGroupsFromChangeItems(changeHistoryItems, issue);
    }

    private List<ChangeHistoryGroup> createChangeGroupsFromChangeItems(List<ChangeHistoryItem> changeHistoryItems, Issue issue) {
        ArrayList filteredChangeItems = Lists.newArrayList(this.filterChangeItems(issue, changeHistoryItems));
        Collections.sort(filteredChangeItems);
        long currentChangeGroup = -1L;
        ChangeHistoryGroup.Builder builder = new ChangeHistoryGroup.Builder();
        ArrayList builders = Lists.newArrayList((Object[])new ChangeHistoryGroup.Builder[]{builder});
        for (ChangeHistoryItem item : filteredChangeItems) {
            if (item.getChangeGroupId() != currentChangeGroup) {
                currentChangeGroup = item.getChangeGroupId();
                builder = new ChangeHistoryGroup.Builder();
                builders.add(builder);
            }
            builder.addChangeItem(item);
        }
        return Lists.transform((List)builders, (Function)new Function<ChangeHistoryGroup.Builder, ChangeHistoryGroup>(){

            public ChangeHistoryGroup apply(@Nullable ChangeHistoryGroup.Builder builder) {
                return builder.build();
            }
        });
    }

    private List<ChangeHistoryItem> filterChangeItems(Issue issue, Collection<ChangeHistoryItem> changeItems) {
        ArrayList<ChangeHistoryItem> changes = new ArrayList<ChangeHistoryItem>();
        for (final IndexedChangeHistoryField field : this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFields()) {
            ImmutableList supportedChangeItems = ImmutableList.copyOf((Iterable)Iterables.filter(changeItems, (Predicate)new Predicate<ChangeHistoryItem>(){

                public boolean apply(ChangeHistoryItem input) {
                    String fieldName = DefaultChangeHistoryRetriever.this.jqlChangeItemMapping.mapJqlClauseToFieldName(field.getFieldName());
                    if (input != null && fieldName.equals(input.getField())) {
                        if (input.getFroms().size() > 0) {
                            DefaultChangeHistoryRetriever.this.changeHistoryConstants.addChangeHistoryFieldConstant(input.getField(), input.getFroms().values().iterator().next(), input.getFroms().keySet().iterator().next());
                        }
                        if (input.getTos().size() > 0) {
                            DefaultChangeHistoryRetriever.this.changeHistoryConstants.addChangeHistoryFieldConstant(input.getField(), input.getTos().values().iterator().next(), input.getTos().keySet().iterator().next());
                        }
                        return true;
                    }
                    return false;
                }
            }));
            if (supportedChangeItems == null) continue;
            changes.addAll(field.getDateRangeBuilder().buildDateRanges(issue, (List<ChangeHistoryItem>)supportedChangeItems));
        }
        return changes;
    }
}

