/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.LuceneUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class ChangeHistoryDocument {
    public static Document getDocument(ChangeHistoryGroup changeHistoryGroup) {
        Document doc = new Document();
        if (changeHistoryGroup != null) {
            String changeItemUser = CaseFolding.foldUsername(changeHistoryGroup.getUser());
            doc.add((Fieldable)new Field("projid", String.valueOf(changeHistoryGroup.getProjectId()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field("issue_id", String.valueOf(changeHistoryGroup.getIssueId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field("key", String.valueOf(changeHistoryGroup.getIssueKey()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field("ch_who", ChangeHistoryDocument.encodeProtocol(changeItemUser), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field("ch_date", LuceneUtils.dateToString(changeHistoryGroup.getCreated()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            for (ChangeHistoryItem changeItem : changeHistoryGroup.getChangeItems()) {
                String changedField = changeItem.getField();
                doc.add((Fieldable)new Field(ChangeHistoryDocument.encodeChangedField(changedField, "ch_duration"), String.valueOf(changeItem.getDuration()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                doc.add((Fieldable)new Field(ChangeHistoryDocument.encodeChangedField(changedField, "ch_nextchangedate"), LuceneUtils.dateToString(changeItem.getNextChangeCreated()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                for (String from : changeItem.getFroms().values()) {
                    doc.add((Fieldable)new Field(ChangeHistoryDocument.encodeChangedField(changedField, "ch_from"), ChangeHistoryDocument.encodeProtocol(from), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                }
                for (String to : changeItem.getTos().values()) {
                    doc.add((Fieldable)new Field(ChangeHistoryDocument.encodeChangedField(changedField, "ch_to"), ChangeHistoryDocument.encodeProtocol(to), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                }
                for (String fromValue : changeItem.getFroms().keySet()) {
                    doc.add((Fieldable)new Field(ChangeHistoryDocument.encodeChangedField(changedField, "ch_oldvalue"), ChangeHistoryDocument.encodeProtocol(fromValue), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                }
                for (String toValue : changeItem.getTos().keySet()) {
                    doc.add((Fieldable)new Field(ChangeHistoryDocument.encodeChangedField(changedField, "ch_newvalue"), ChangeHistoryDocument.encodeProtocol(toValue), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                }
            }
            return doc;
        }
        return null;
    }

    private static String encodeChangedField(String changedField, String docConstant) {
        return changedField + "." + docConstant;
    }

    private static String encodeProtocol(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem.toLowerCase());
    }
}

