/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeScreenSchemeImpl
extends AbstractGVBean
implements IssueTypeScreenScheme {
    private Long id;
    private String name;
    private String description;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private Map schemeEntities;

    public IssueTypeScreenSchemeImpl(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, GenericValue genericValue) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.setGenericValue(genericValue);
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.name = this.getGenericValue().getString("name");
            this.description = this.getGenericValue().getString("description");
        }
        this.setModified(false);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        if (this.getGenericValue() != null) {
            throw new IllegalStateException("Cannot change id of an existing entity.");
        }
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.updateGV("name", name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.updateGV("description", description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() {
        List<Object> schemeEntitiesToStore;
        if (this.isModified()) {
            if (this.getGenericValue() == null) {
                this.issueTypeScreenSchemeManager.createIssueTypeScreenScheme(this);
            } else {
                this.issueTypeScreenSchemeManager.updateIssueTypeScreenScheme(this);
                this.setModified(false);
            }
        }
        IssueTypeScreenSchemeImpl issueTypeScreenSchemeImpl = this;
        synchronized (issueTypeScreenSchemeImpl) {
            schemeEntitiesToStore = this.schemeEntities == null ? Collections.EMPTY_LIST : new ArrayList(this.schemeEntities.values());
        }
        for (IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity : schemeEntitiesToStore) {
            issueTypeScreenSchemeEntity.store();
        }
    }

    @Override
    public void remove() {
        this.issueTypeScreenSchemeManager.removeIssueTypeSchemeEntities(this);
        if (this.getGenericValue() != null) {
            this.issueTypeScreenSchemeManager.removeIssueTypeScreenScheme(this);
        }
    }

    @Override
    public Collection getEntities() {
        LinkedList entities = new LinkedList(this.getInternalEntities().values());
        Collections.sort(entities);
        return Collections.unmodifiableCollection(entities);
    }

    @Override
    public IssueTypeScreenSchemeEntity getEntity(String issueTypeId) {
        return (IssueTypeScreenSchemeEntity)this.getInternalEntities().get(issueTypeId);
    }

    @Override
    public void addEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        issueTypeScreenSchemeEntity.setIssueTypeScreenScheme(this);
        this.recordEntity(issueTypeScreenSchemeEntity);
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntity(String issueTypeId) {
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity;
        IssueTypeScreenSchemeImpl issueTypeScreenSchemeImpl = this;
        synchronized (issueTypeScreenSchemeImpl) {
            if (!this.containsEntity(issueTypeId)) {
                return;
            }
            issueTypeScreenSchemeEntity = this.getEntity(issueTypeId);
            this.schemeEntities.remove(issueTypeId);
        }
        if (issueTypeScreenSchemeEntity != null) {
            issueTypeScreenSchemeEntity.remove();
        }
    }

    @Override
    public boolean containsEntity(String issueTypeId) {
        return this.getInternalEntities().containsKey(issueTypeId);
    }

    @Override
    public Collection getProjects() {
        return this.issueTypeScreenSchemeManager.getProjects(this);
    }

    @Override
    public boolean isDefault() {
        return DEFAULT_SCHEME_ID.equals(this.getId());
    }

    private synchronized Map getInternalEntities() {
        if (this.schemeEntities == null) {
            this.schemeEntities = new HashMap();
            for (Object o : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemeEntities(this)) {
                IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = (IssueTypeScreenSchemeEntity)o;
                this.recordEntity(issueTypeScreenSchemeEntity);
            }
        }
        return Collections.unmodifiableMap(this.schemeEntities);
    }

    private synchronized void recordEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        this.getInternalEntities();
        if (issueTypeScreenSchemeEntity.getIssueTypeId() != null) {
            this.schemeEntities.put(issueTypeScreenSchemeEntity.getIssueTypeId(), issueTypeScreenSchemeEntity);
        } else {
            this.schemeEntities.put(null, issueTypeScreenSchemeEntity);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IssueTypeScreenSchemeImpl)) {
            return false;
        }
        IssueTypeScreenScheme issueTypeScreenScheme = (IssueTypeScreenScheme)o;
        if (this.description != null ? !this.description.equals(issueTypeScreenScheme.getDescription()) : issueTypeScreenScheme.getDescription() != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(issueTypeScreenScheme.getId()) : issueTypeScreenScheme.getId() != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(issueTypeScreenScheme.getName()) : issueTypeScreenScheme.getName() != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

