/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueTypeScreenSchemeStore
implements IssueTypeScreenSchemeStore {
    private final OfBizDelegator ofBizDelegator;
    private IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;

    public DefaultIssueTypeScreenSchemeStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Collection getIssueTypeScreenSchemes() {
        List<GenericValue> issueTypeScreenSchemeGVs = this.ofBizDelegator.findAll("IssueTypeScreenScheme", EasyList.build((Object)"name"));
        return this.buildIssueTypeScreenSchemes(issueTypeScreenSchemeGVs);
    }

    private Collection buildIssueTypeScreenSchemes(List issueTypeScreenSchemeGVs) {
        LinkedList<IssueTypeScreenScheme> issueTypeScreenSchemes = new LinkedList<IssueTypeScreenScheme>();
        Iterator iterator = issueTypeScreenSchemeGVs.iterator();
        while (iterator.hasNext()) {
            issueTypeScreenSchemes.add(this.buildIssueTypeScreenScheme((GenericValue)iterator.next()));
        }
        return issueTypeScreenSchemes;
    }

    private IssueTypeScreenScheme buildIssueTypeScreenScheme(GenericValue genericValue) {
        return new IssueTypeScreenSchemeImpl(this.getIssueTypeScreenSchemeManager(), genericValue);
    }

    @Override
    public IssueTypeScreenScheme getIssueTypeScreenScheme(Long id) {
        GenericValue issueTypeScreenSchemeGV = this.ofBizDelegator.findByPrimaryKey("IssueTypeScreenScheme", EasyMap.build((Object)"id", (Object)id));
        return this.buildIssueTypeScreenScheme(issueTypeScreenSchemeGV);
    }

    public IssueTypeScreenSchemeManager getIssueTypeScreenSchemeManager() {
        return this.issueTypeScreenSchemeManager;
    }

    public void setIssueTypeScreenSchemeManager(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
    }
}

