/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.AbstractFieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTabImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Predicates;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

class StandardFieldScreenRendererFactory {
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldScreenManager fieldScreenManager;

    StandardFieldScreenRendererFactory(FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenManager fieldScreenManager) {
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue, IssueOperation issueOperation, Predicate<? super Field> predicate) {
        FieldScreenScheme fieldScreenScheme = this.issueTypeScreenSchemeManager.getFieldScreenScheme(issue);
        return this.createFieldScreenRenderer(issue, fieldScreenScheme.getFieldScreen(issueOperation), issueOperation, predicate);
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue, ActionDescriptor actionDescriptor) {
        return this.createFieldScreenRenderer(issue, this.getScreenFromAction(actionDescriptor), null, Predicates.truePredicate());
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue) {
        return this.createFieldScreenRenderer(issue, Collections.<FieldScreenTab>emptyList(), null, Predicates.truePredicate());
    }

    FieldScreenRenderer createFieldScreenRenderer(List<String> fieldIds, Issue issue, IssueOperation issueOperation) {
        SubTaskFieldScreenTab tab = new SubTaskFieldScreenTab(fieldIds, this.fieldScreenManager, this.fieldManager);
        return this.createFieldScreenRenderer(issue, Collections.singletonList(tab), issueOperation, Predicates.truePredicate());
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue, FieldScreen fieldScreen, IssueOperation operation, Predicate<? super Field> condition) {
        List<FieldScreenTab> fieldScreenTabs = fieldScreen == null ? Collections.emptyList() : fieldScreen.getTabs();
        return this.createFieldScreenRenderer(issue, fieldScreenTabs, operation, condition);
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue, Collection<FieldScreenTab> tabs, IssueOperation operation, Predicate<? super Field> condition) {
        FieldLayout fieldLayout = this.getFieldLayout(issue);
        Set<Field> unavailableFields = this.fieldManager.getUnavailableFields();
        ArrayList<FieldScreenRenderTabImpl> fieldScreenRenderTabs = new ArrayList<FieldScreenRenderTabImpl>();
        int i = 0;
        for (FieldScreenTab fieldScreenTab : tabs) {
            ArrayList<FieldScreenRenderLayoutItem> fieldScreenRenderLayoutItems = new ArrayList<FieldScreenRenderLayoutItem>();
            for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenTab.getFieldScreenLayoutItems()) {
                FieldLayoutItem fieldLayoutItem;
                OrderableField orderableField = fieldScreenLayoutItem.getOrderableField();
                if (orderableField == null || !condition.evaluate(orderableField) || unavailableFields.contains(orderableField) || (fieldLayoutItem = fieldLayout.getFieldLayoutItem(orderableField)).isHidden() || !fieldScreenLayoutItem.isShown(issue)) continue;
                if (this.fieldManager.isCustomField(orderableField)) {
                    FieldScreenRenderLayoutItem customFieldRenderLayoutItem = this.getCustomFieldRenderLayoutItem(issue, operation, fieldLayoutItem, fieldScreenLayoutItem);
                    if (customFieldRenderLayoutItem == null) continue;
                    fieldScreenRenderLayoutItems.add(customFieldRenderLayoutItem);
                    continue;
                }
                fieldScreenRenderLayoutItems.add(new FieldScreenRenderLayoutItemImpl(fieldScreenLayoutItem, fieldLayoutItem));
            }
            if (fieldScreenRenderLayoutItems.isEmpty()) continue;
            FieldScreenRenderTabImpl fieldScreenRenderTab = new FieldScreenRenderTabImpl(fieldScreenTab.getName(), i++, fieldScreenRenderLayoutItems);
            fieldScreenRenderTabs.add(fieldScreenRenderTab);
        }
        return new FieldScreenRendererImpl(Collections.unmodifiableList(fieldScreenRenderTabs), fieldLayout);
    }

    FieldScreen getScreenFromAction(ActionDescriptor descriptor) {
        WorkflowActionsBean workflowActionsBean = new WorkflowActionsBean();
        return workflowActionsBean.getFieldScreenForView(descriptor);
    }

    private FieldScreenRenderLayoutItem getCustomFieldRenderLayoutItem(Issue issue, IssueOperation issueOperation, FieldLayoutItem fieldLayoutItem, FieldScreenLayoutItem fieldScreenLayoutItem) {
        CustomField customField = (CustomField)fieldLayoutItem.getOrderableField();
        if (customField.isInScope(issue.getProjectObject(), Collections.singletonList(issue.getIssueTypeObject().getId()))) {
            if (IssueOperations.VIEW_ISSUE_OPERATION.equals(issueOperation)) {
                if (customField.getCustomFieldType().getDescriptor().isViewTemplateExists() && customField.getValue(issue) != null) {
                    return new FieldScreenRenderLayoutItemImpl(fieldScreenLayoutItem, fieldLayoutItem);
                }
            } else {
                return new FieldScreenRenderLayoutItemImpl(fieldScreenLayoutItem, fieldLayoutItem);
            }
        }
        return null;
    }

    private FieldLayout getFieldLayout(Issue issue) {
        return this.fieldLayoutManager.getFieldLayout(issue);
    }

    private static class SubTaskFieldScreenlayoutItem
    extends AbstractFieldScreenLayoutItem {
        public SubTaskFieldScreenlayoutItem(FieldScreenManager fieldScreenManager, FieldManager fieldManager) {
            super(fieldScreenManager, fieldManager);
        }

        @Override
        protected void init() {
        }

        @Override
        public void setPosition(int position) {
            this.position = position;
        }

        @Override
        public void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public void setFieldScreenTab(FieldScreenTab fieldScreenTab) {
            this.fieldScreenTab = fieldScreenTab;
        }

        @Override
        public Long getId() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void store() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }

    private static class SubTaskFieldScreenTab
    implements FieldScreenTab {
        private final Map<String, FieldScreenLayoutItem> fieldLayoutItems = new LinkedHashMap<String, FieldScreenLayoutItem>();

        public SubTaskFieldScreenTab(List<String> fieldIds, FieldScreenManager fieldScreenManager, FieldManager fieldManager) {
            int i = 0;
            for (String fieldId : fieldIds) {
                SubTaskFieldScreenlayoutItem fieldScreenLayoutItem = new SubTaskFieldScreenlayoutItem(fieldScreenManager, fieldManager);
                fieldScreenLayoutItem.setPosition(i);
                fieldScreenLayoutItem.setFieldId(fieldId);
                fieldScreenLayoutItem.setFieldScreenTab(this);
                this.fieldLayoutItems.put(fieldId, fieldScreenLayoutItem);
                ++i;
            }
        }

        @Override
        public int getPosition() {
            return 0;
        }

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public List<FieldScreenLayoutItem> getFieldScreenLayoutItems() {
            return new ArrayList<FieldScreenLayoutItem>(this.fieldLayoutItems.values());
        }

        @Override
        public FieldScreenLayoutItem getFieldScreenLayoutItem(int poistion) {
            return this.getFieldScreenLayoutItems().get(poistion);
        }

        @Override
        public FieldScreenLayoutItem getFieldScreenLayoutItem(String fieldId) {
            return this.fieldLayoutItems.get(fieldId);
        }

        @Override
        public boolean isContainsField(String fieldId) {
            return this.fieldLayoutItems.containsKey(fieldId);
        }

        @Override
        public String getName() {
            return "Sub Task Quick Creation Tab";
        }

        @Override
        public Long getId() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void setPosition(int position) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void addFieldScreenLayoutItem(String fieldId) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void addFieldScreenLayoutItem(String fieldId, int position) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void moveFieldScreenLayoutItemFirst(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void moveFieldScreenLayoutItemUp(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void moveFieldScreenLayoutItemDown(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void moveFieldScreenLayoutItemLast(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public FieldScreenLayoutItem removeFieldScreenLayoutItem(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void moveFieldScreenLayoutItemToPosition(Map positionsToFields) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public GenericValue getGenericValue() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void setGenericValue(GenericValue genericValue) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void setFieldScreen(FieldScreen fieldScreen) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public FieldScreen getFieldScreen() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void store() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

