/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import org.ofbiz.core.entity.GenericValue;

public class FieldScreenSchemeItemImpl
extends AbstractGVBean
implements FieldScreenSchemeItem {
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private Long id;
    private ScreenableIssueOperation issueOperation;
    private Long fieldScreenId;
    private FieldScreenScheme fieldScreenScheme;
    private FieldScreenManager fieldScreenManager;

    public FieldScreenSchemeItemImpl(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenManager fieldScreenManager) {
        this(fieldScreenSchemeManager, (GenericValue)null, fieldScreenManager);
    }

    public FieldScreenSchemeItemImpl(FieldScreenSchemeManager fieldScreenSchemeManager, GenericValue genericValue, FieldScreenManager fieldScreenManager) {
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.setGenericValue(genericValue);
    }

    public FieldScreenSchemeItemImpl(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenSchemeItem fieldScreenSchemeItem, FieldScreenManager fieldScreenManager) {
        this(fieldScreenSchemeManager, (GenericValue)null, fieldScreenManager);
        this.setIssueOperation(fieldScreenSchemeItem.getIssueOperation());
        this.setFieldScreen(fieldScreenSchemeItem.getFieldScreen());
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
        }
        this.setModified(false);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public ScreenableIssueOperation getIssueOperation() {
        return this.issueOperation;
    }

    @Override
    public void setIssueOperation(ScreenableIssueOperation issueOperation) {
        this.issueOperation = issueOperation;
        if (issueOperation != null) {
            this.updateGV("operation", issueOperation.getId());
        } else {
            this.updateGV("operation", null);
        }
    }

    @Override
    public FieldScreen getFieldScreen() {
        return this.fieldScreenManager.getFieldScreen(this.fieldScreenId);
    }

    @Override
    public String getIssueOperationName() {
        if (this.getIssueOperation() != null) {
            return this.getIssueOperation().getNameKey();
        }
        return "admin.common.words.default";
    }

    @Override
    public void setFieldScreen(FieldScreen fieldScreen) {
        if (fieldScreen != null) {
            this.fieldScreenId = fieldScreen.getId();
            this.updateGV("fieldscreen", this.fieldScreenId);
        } else {
            this.fieldScreenId = null;
            this.updateGV("fieldscreen", null);
        }
    }

    @Override
    public FieldScreenScheme getFieldScreenScheme() {
        return this.fieldScreenScheme;
    }

    @Override
    public void setFieldScreenScheme(FieldScreenScheme fieldScreenScheme) {
        this.fieldScreenScheme = fieldScreenScheme;
        if (fieldScreenScheme != null) {
            this.updateGV("fieldscreenscheme", fieldScreenScheme.getId());
        } else {
            this.updateGV("fieldscreenscheme", null);
        }
    }

    @Override
    public Long getFieldScreenId() {
        return this.fieldScreenId;
    }

    @Override
    public void store() {
        if (this.isModified()) {
            if (this.id == null) {
                this.fieldScreenSchemeManager.createFieldScreenSchemeItem(this);
            } else {
                this.fieldScreenSchemeManager.updateFieldScreenSchemeItem(this);
                this.setModified(false);
            }
        }
    }

    @Override
    public void remove() {
        if (this.id != null) {
            this.fieldScreenSchemeManager.removeFieldScreenSchemeItem(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldScreenSchemeItem)) {
            return false;
        }
        FieldScreenSchemeItemImpl fieldScreenSchemeItem = (FieldScreenSchemeItemImpl)o;
        if (this.getFieldScreenId() != null ? !this.getFieldScreenId().equals(fieldScreenSchemeItem.getFieldScreenId()) : fieldScreenSchemeItem.getFieldScreenId() != null) {
            return false;
        }
        if (this.fieldScreenScheme != null ? !this.fieldScreenScheme.equals(fieldScreenSchemeItem.getFieldScreenScheme()) : fieldScreenSchemeItem.getFieldScreenScheme() != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(fieldScreenSchemeItem.getId()) : fieldScreenSchemeItem.getId() != null) {
            return false;
        }
        return !(this.issueOperation != null ? !this.issueOperation.equals(fieldScreenSchemeItem.getIssueOperation()) : fieldScreenSchemeItem.getIssueOperation() != null);
    }

    public int hashCode() {
        int result = this.issueOperation != null ? this.issueOperation.hashCode() : 0;
        result = 29 * result + (this.getFieldScreenId() != null ? this.getFieldScreenId().hashCode() : 0);
        result = 29 * result + (this.fieldScreenScheme != null ? this.fieldScreenScheme.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(FieldScreenSchemeItem o) {
        ScreenableIssueOperation issueOperation1 = this.getIssueOperation();
        ScreenableIssueOperation issueOperation2 = o.getIssueOperation();
        if (issueOperation1 == null) {
            if (issueOperation2 == null) {
                return 0;
            }
            return -1;
        }
        if (issueOperation2 == null) {
            return 1;
        }
        return issueOperation1.getId().compareTo(issueOperation2.getId());
    }
}

