/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class DefaultProjectFieldScreenHelper
implements ProjectFieldScreenHelper {
    private final ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper;
    private final ProjectIssueTypeScreenSchemeHelper issueTypeScreenSchemeHelper;
    private final WorkflowManager workflowManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;

    public DefaultProjectFieldScreenHelper(ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper, ProjectIssueTypeScreenSchemeHelper issueTypeScreenSchemeHelper, WorkflowManager workflowManager, FieldScreenSchemeManager fieldScreenSchemeManager) {
        this.projectWorkflowSchemeHelper = projectWorkflowSchemeHelper;
        this.issueTypeScreenSchemeHelper = issueTypeScreenSchemeHelper;
        this.workflowManager = workflowManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
    }

    @Override
    public List<Project> getProjectsForFieldScreen(FieldScreen fieldScreen) {
        WorkflowActionsBean actionsBean = this.getActionsBean();
        TreeSet projects = Sets.newTreeSet(ProjectNameComparator.COMPARATOR);
        HashSet matchingWorkflows = Sets.newHashSet();
        Collection<JiraWorkflow> activeWorkflows = this.workflowManager.getActiveWorkflows();
        block0: for (JiraWorkflow activeWorkflow : activeWorkflows) {
            Collection<ActionDescriptor> allActions = activeWorkflow.getAllActions();
            for (ActionDescriptor actionDescriptor : allActions) {
                FieldScreen fieldScreenForView = actionsBean.getFieldScreenForView(actionDescriptor);
                if (fieldScreenForView == null || !fieldScreenForView.equals(fieldScreen)) continue;
                matchingWorkflows.add(activeWorkflow.getName());
                continue block0;
            }
        }
        HashSet fieldScreenSchemes = Sets.newHashSet(this.fieldScreenSchemeManager.getFieldScreenSchemes(fieldScreen));
        projects.addAll(this.projectWorkflowSchemeHelper.getProjectsForWorkflow(matchingWorkflows).values());
        projects.addAll(this.issueTypeScreenSchemeHelper.getProjectsForFieldScreenSchemes(fieldScreenSchemes).values());
        return Lists.newArrayList((Iterable)projects);
    }

    WorkflowActionsBean getActionsBean() {
        return new WorkflowActionsBean();
    }
}

