/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenStore;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.set.ListOrderedSet;

public class DefaultFieldScreenManager
implements FieldScreenManager {
    private final FieldScreenStore fieldScreenStore;

    public DefaultFieldScreenManager(FieldScreenStore fieldScreenStore) {
        this.fieldScreenStore = fieldScreenStore;
        this.fieldScreenStore.setFieldScreenManager(this);
        this.fieldScreenStore.refresh();
    }

    @Override
    public FieldScreen getFieldScreen(Long id) {
        return this.fieldScreenStore.getFieldScreen(id);
    }

    @Override
    public Collection<FieldScreen> getFieldScreens() {
        return this.fieldScreenStore.getFieldScreens();
    }

    @Override
    public Collection<FieldScreenTab> getFieldScreenTabs(String fieldId) {
        ListOrderedSet fieldScreenTabs = new ListOrderedSet();
        for (FieldScreen fieldScreen : this.getFieldScreens()) {
            for (FieldScreenTab fieldScreenTab : fieldScreen.getTabs()) {
                if (fieldScreenTab.getFieldScreenLayoutItem(fieldId) == null) continue;
                fieldScreenTabs.add(fieldScreenTab);
            }
        }
        return fieldScreenTabs;
    }

    @Override
    public void createFieldScreen(FieldScreen fieldScreen) {
        this.fieldScreenStore.createFieldScreen(fieldScreen);
    }

    @Override
    public void removeFieldScreen(Long id) {
        this.fieldScreenStore.removeFieldScreen(id);
    }

    @Override
    public void updateFieldScreen(FieldScreen fieldScreen) {
        this.fieldScreenStore.updateFieldScreen(fieldScreen);
    }

    @Override
    public void createFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.fieldScreenStore.createFieldScreenTab(fieldScreenTab);
    }

    @Override
    public void updateFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.fieldScreenStore.updateFieldScreenTab(fieldScreenTab);
    }

    @Override
    public FieldScreenTab getFieldScreenTab(Long fieldScreenTabId) {
        return this.fieldScreenStore.getFieldScreenTab(fieldScreenTabId);
    }

    @Override
    public List<FieldScreenTab> getFieldScreenTabs(FieldScreen fieldScreen) {
        return this.fieldScreenStore.getFieldScreenTabs(fieldScreen);
    }

    @Override
    public void createFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.fieldScreenStore.createFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void updateFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.fieldScreenStore.updateFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.fieldScreenStore.removeFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        this.fieldScreenStore.removeFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        return this.fieldScreenStore.getFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public void removeFieldScreenItems(String fieldId) {
        for (FieldScreen fieldScreen : this.getFieldScreens()) {
            if (!fieldScreen.containsField(fieldId)) continue;
            fieldScreen.removeFieldScreenLayoutItem(fieldId);
        }
    }

    @Override
    public void refresh() {
        this.fieldScreenStore.refresh();
    }

    @Override
    public FieldScreenLayoutItem buildNewFieldScreenLayoutItem(String fieldId) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.fieldScreenStore.buildNewFieldScreenLayoutItem(null);
        fieldScreenLayoutItem.setFieldId(fieldId);
        return fieldScreenLayoutItem;
    }

    @Override
    public void removeFieldScreenTabs(FieldScreen fieldScreen) {
        this.fieldScreenStore.removeFieldScreenTabs(fieldScreen);
    }

    @Override
    public void removeFieldScreenTab(Long id) {
        this.fieldScreenStore.removeFieldScreenTab(id);
    }
}

