/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.TimeTrackingSystemField;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.beans.TimeTrackingJsonBean;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimeTrackingRestFieldOperationsHandler
implements RestFieldOperationsHandler {
    private final TimeTrackingSystemField field;
    private final ApplicationProperties applicationProperties;
    private final JiraDurationUtils jiraDurationUtils;
    private final I18nHelper i18nHelper;

    public TimeTrackingRestFieldOperationsHandler(TimeTrackingSystemField field, ApplicationProperties applicationProperties, JiraDurationUtils jiraDurationUtils, I18nHelper i18nHelper) {
        this.field = field;
        this.applicationProperties = applicationProperties;
        this.jiraDurationUtils = jiraDurationUtils;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.SET.getName(), (Object)StandardOperation.EDIT.getName());
    }

    @Override
    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (operations.isEmpty()) {
            return errors;
        }
        if (operations.size() > 1) {
            errors.addError("timetracking", this.i18nHelper.getText("rest.operations.morethanone", String.valueOf(operations.size()), fieldId));
            return errors;
        }
        FieldOperationHolder fieldOperationHolder = operations.get(0);
        StandardOperation standardOperation = StandardOperation.valueOf(fieldOperationHolder.getOperation().toUpperCase());
        TimeTrackingJsonBean timeTrackingJsonBean = fieldOperationHolder.getData().convertValue("timetracking", TimeTrackingJsonBean.class, (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        switch (standardOperation) {
            case SET: {
                this.performSetOperation(timeTrackingJsonBean, inputParameters, issue, errors);
                break;
            }
            case EDIT: {
                this.performEditOperation(timeTrackingJsonBean, inputParameters, issue, errors);
            }
        }
        return errors;
    }

    private void performSetOperation(TimeTrackingJsonBean timeTrackingJsonBean, IssueInputParameters inputParameters, Issue issue, ErrorCollection errors) {
        String estimate = timeTrackingJsonBean.getRemainingEstimate();
        String originalEstimate = timeTrackingJsonBean.getOriginalEstimate();
        Map<String, String[]> actionParameters = inputParameters.getActionParameters();
        if (timeTrackingJsonBean.getTimeSpent() != null) {
            errors.addError("timetracking", this.i18nHelper.getText("rest.timetracking.cannot.set.timespent"), ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if (this.applicationProperties.getOption("jira.timetracking.estimates.legacy.behaviour")) {
            if (originalEstimate != null) {
                if (issue != null && this.field.hasWorkStarted(issue)) {
                    errors.addError("timetracking", this.i18nHelper.getText("rest.timetracking.cannot.set.original.work.started"), ErrorCollection.Reason.VALIDATION_FAILED);
                } else if (estimate != null) {
                    errors.addError("timetracking", this.i18nHelper.getText("rest.timetracking.cannot.set.both.legacy"), ErrorCollection.Reason.VALIDATION_FAILED);
                } else {
                    actionParameters.put("timetracking", new String[]{originalEstimate});
                }
            } else {
                actionParameters.put("timetracking", new String[]{estimate});
            }
        } else {
            actionParameters.put("timetracking_originalestimate", new String[]{originalEstimate});
            actionParameters.put("timetracking_remainingestimate", new String[]{estimate});
            actionParameters.put("timetracking", new String[0]);
        }
    }

    private void performEditOperation(TimeTrackingJsonBean timeTrackingJsonBean, IssueInputParameters inputParameters, Issue issue, ErrorCollection errors) {
        String currentEstimate = issue.getEstimate() == null ? null : this.jiraDurationUtils.getShortFormattedDuration(issue.getEstimate());
        String currentOriginalEstimate = issue.getOriginalEstimate() == null ? null : this.jiraDurationUtils.getShortFormattedDuration(issue.getOriginalEstimate());
        String estimate = timeTrackingJsonBean.getRemainingEstimate();
        String originalEstimate = timeTrackingJsonBean.getOriginalEstimate();
        Map<String, String[]> actionParameters = inputParameters.getActionParameters();
        if (timeTrackingJsonBean.getTimeSpent() != null) {
            errors.addError("timetracking", this.i18nHelper.getText("rest.timetracking.cannot.set.timespent"), ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if (this.applicationProperties.getOption("jira.timetracking.estimates.legacy.behaviour")) {
            actionParameters.put("timetracking", new String[]{estimate});
            if (originalEstimate != null) {
                errors.addError("timetracking", this.i18nHelper.getText("rest.timetracking.cannot.set.original.work.started"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else {
            if (originalEstimate != null) {
                actionParameters.put("timetracking_originalestimate", new String[]{originalEstimate});
            } else {
                actionParameters.put("timetracking_originalestimate", new String[]{currentOriginalEstimate});
            }
            if (estimate != null) {
                actionParameters.put("timetracking_remainingestimate", new String[]{estimate});
            } else {
                actionParameters.put("timetracking_remainingestimate", new String[]{currentEstimate});
            }
            actionParameters.put("timetracking", new String[0]);
        }
    }
}

