/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class IssueFinderImpl
implements IssueFinder {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueService issueManager;
    private final I18nHelper.BeanFactory i18nFactory;

    public IssueFinderImpl(JiraAuthenticationContext jiraAuthenticationContext, IssueService issueManager, PermissionManager permissionManager, I18nHelper.BeanFactory i18nFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueManager = issueManager;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public Issue findIssue(@Nonnull IssueRefJsonBean issueRef, @Nonnull ErrorCollection errorCollection) {
        IssueService.IssueResult result = this.getIssue(issueRef);
        if (result != null) {
            errorCollection.addErrorCollection(result.getErrorCollection());
            return result.getIssue();
        }
        errorCollection.addErrorMessage(this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser()).getText("rest.issue.key.or.id.required"));
        return null;
    }

    private IssueService.IssueResult getIssue(IssueRefJsonBean issueRef) {
        if (StringUtils.isNotBlank((String)issueRef.id())) {
            return this.issueManager.getIssue(this.jiraAuthenticationContext.getLoggedInUser(), Long.parseLong(issueRef.id()));
        }
        if (StringUtils.isNotBlank((String)issueRef.key())) {
            return this.issueManager.getIssue(this.jiraAuthenticationContext.getLoggedInUser(), issueRef.key());
        }
        return null;
    }
}

