/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CommentRestFieldOperationsHandler
implements RestFieldOperationsHandler {
    private final CommentManager commentManager;
    private final ProjectRoleManager projectRoleManager;
    private final I18nHelper i18nHelper;

    public CommentRestFieldOperationsHandler(CommentManager commentManager, ProjectRoleManager projectRoleManager, I18nHelper i18nHelper) {
        this.commentManager = commentManager;
        this.projectRoleManager = projectRoleManager;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName(), (Object)StandardOperation.EDIT.getName(), (Object)StandardOperation.REMOVE.getName());
    }

    @Override
    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (operations.isEmpty()) {
            return errors;
        }
        if (operations.size() > 1) {
            errors.addError("comment", this.i18nHelper.getText("rest.operations.morethanone", String.valueOf(operations.size()), fieldId));
            return errors;
        }
        FieldOperationHolder fieldOperationHolder = operations.get(0);
        StandardOperation standardOperation = StandardOperation.valueOf(fieldOperationHolder.getOperation().toUpperCase());
        CommentJsonBean commentJsonBean = fieldOperationHolder.getData().convertValue("comment", CommentJsonBean.class, (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        switch (standardOperation) {
            case ADD: {
                this.performAddOperation(commentJsonBean, inputParameters, errors);
                break;
            }
            case EDIT: {
                this.performEditOperation(commentJsonBean, inputParameters, errors);
                break;
            }
            case REMOVE: {
                this.performRemoveOperation(commentJsonBean, inputParameters, errors);
            }
        }
        if (standardOperation.equals((Object)StandardOperation.REMOVE) || !commentJsonBean.isVisibilitySet()) {
            return errors;
        }
        VisibilityJsonBean commentVisibility = commentJsonBean.getVisibility();
        String securityLevel = null;
        if (commentVisibility == null) {
            securityLevel = CommentVisibility.getRoleLevelWithPrefix("");
        } else if (commentVisibility.getType().equals((Object)VisibilityJsonBean.VisibilityType.group)) {
            String group = commentVisibility.getValue();
            if (StringUtils.isNotEmpty((String)group)) {
                securityLevel = CommentVisibility.getCommentLevelFromLevels(group, null);
            } else {
                errors.addError("comment", this.i18nHelper.getText("rest.comment.visibility.group.no.value"));
            }
        } else {
            String roleLevel = commentVisibility.getValue();
            if (StringUtils.isNotEmpty((String)roleLevel)) {
                Long roleLevelId;
                ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleLevel);
                if (projectRole != null) {
                    roleLevelId = projectRole.getId();
                } else {
                    try {
                        roleLevelId = Long.valueOf(roleLevel);
                    }
                    catch (NumberFormatException ex) {
                        errors.addError("comment", this.i18nHelper.getText("rest.comment.visibility.role.level.invalid"));
                        return errors;
                    }
                }
                securityLevel = CommentVisibility.getCommentLevelFromLevels(null, roleLevelId);
            } else {
                errors.addError("comment", this.i18nHelper.getText("rest.comment.visibility.role.level.no.value"));
            }
        }
        ArrayList<String> commentSecurity = new ArrayList<String>();
        commentSecurity.add(securityLevel);
        inputParameters.getActionParameters().put("commentLevel", commentSecurity.toArray(new String[commentSecurity.size()]));
        return errors;
    }

    private void performEditOperation(CommentJsonBean commentJson, IssueInputParameters parameters, ErrorCollection errors) {
        ArrayList<String> commentParams;
        block6: {
            parameters.getActionParameters().put("comment.edit.param", new String[]{"true"});
            if (StringUtils.isNotEmpty((String)commentJson.getId())) {
                parameters.getActionParameters().put("comment:id", new String[]{commentJson.getId()});
            }
            commentParams = new ArrayList<String>();
            if (commentJson.getBody() == null) {
                try {
                    Comment comment = this.commentManager.getCommentById(Long.valueOf(commentJson.getId()));
                    if (comment != null) {
                        commentParams.add(comment.getBody());
                        break block6;
                    }
                    commentParams.add("DUMMY BODY");
                }
                catch (NumberFormatException ex) {
                    commentParams.add("DUMMY BODY");
                }
            } else {
                commentParams.add(commentJson.getBody());
            }
        }
        parameters.getActionParameters().put("comment", commentParams.toArray(new String[commentParams.size()]));
    }

    private void performAddOperation(CommentJsonBean commentJson, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.getActionParameters().put("comment.create.param", new String[]{"true"});
        ArrayList<String> commentParams = new ArrayList<String>();
        commentParams.add(commentJson.getBody());
        parameters.getActionParameters().put("comment", commentParams.toArray(new String[commentParams.size()]));
    }

    private void performRemoveOperation(CommentJsonBean commentJson, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.getActionParameters().put("comment.remove.param", new String[]{"true"});
        ArrayList<String> commentParams = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)commentJson.getId())) {
            parameters.getActionParameters().put("comment:id", new String[]{commentJson.getId()});
        }
        commentParams.add("DUMMY BODY");
        parameters.getActionParameters().put("comment", commentParams.toArray(new String[commentParams.size()]));
    }
}

