/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.links;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.BaseLink;
import com.atlassian.renderer.links.GenericLinkParser;
import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;

public class JiraUserProfileLink
extends BaseLink {
    private User user;

    public JiraUserProfileLink(GenericLinkParser parser, RenderContext context) {
        super(parser);
        if (TextUtils.stringSet((String)parser.getNotLinkBody()) && parser.getNotLinkBody().startsWith("~")) {
            try {
                String username = parser.getNotLinkBody().substring(1);
                this.user = UserUtils.getUser(username);
                this.linkBody = this.user != null && this.user.getDisplayName() != null ? this.user.getDisplayName() : username;
                this.url = this.buildProfileUrl(context, username);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getLinkAttributes() {
        if (this.user != null) {
            return super.getLinkAttributes() + " class=\"user-hover\" rel=\"" + this.user.getName() + "\"";
        }
        return super.getLinkAttributes();
    }

    private String buildProfileUrl(RenderContext context, String username) throws UnsupportedEncodingException {
        String encodedUsername = URLCodec.encode(username, context.getCharacterEncoding());
        return context.getBaseUrl() + "/secure/ViewProfile.jspa?name=" + encodedUsername;
    }

    public User getUser() {
        return this.user;
    }
}

