/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.links;

import com.atlassian.jira.issue.fields.renderer.wiki.links.JiraIssueLink;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.AbstractRendererComponent;
import com.atlassian.renderer.v2.components.link.LinkDecorator;
import com.opensymphony.util.TextUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MatchResult;

public class JiraIssueLinkRendererComponent
extends AbstractRendererComponent {
    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderLinks();
    }

    public String render(String wiki, RenderContext context) {
        return this.linkBugKeys(wiki, context);
    }

    private String linkBugKeys(String body, RenderContext context) {
        if (!TextUtils.stringSet((String)body)) {
            return "";
        }
        Perl5Util util = new Perl5Util();
        StringBuilder buff = new StringBuilder(body.length());
        String issueKeyRegex = JiraKeyUtils.getIssueKeyRegex();
        while (util.match(issueKeyRegex, body)) {
            MatchResult match = util.getMatch();
            buff.append(body.substring(0, match.beginOffset(2)));
            StringBuffer sb = new StringBuffer();
            int matchGroups = match.groups();
            for (int i = 2; i < matchGroups; ++i) {
                sb.append(match.group(i));
            }
            String key = sb.toString();
            if (JiraKeyUtils.isPartOfUrl(body, match.beginOffset(2))) {
                buff.append(key);
            } else {
                try {
                    JiraIssueLink link = new JiraIssueLink(key);
                    buff.append(context.getRenderedContentStore().addInline((Object)new LinkDecorator((Link)link)));
                }
                catch (Exception iae) {
                    buff.append(key);
                }
            }
            body = body.substring(match.endOffset(matchGroups - 1));
        }
        buff.append(body);
        return buff.toString();
    }
}

