/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachment;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.v2.RenderUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class RendererAttachmentManager
implements com.atlassian.renderer.attachments.RendererAttachmentManager {
    private static final Logger log = Logger.getLogger(RendererAttachmentManager.class);
    private AttachmentManager attachmentManager;
    private ThumbnailManager thumbnailManager;
    private JiraAuthenticationContext authenticationContext;

    public RendererAttachmentManager(AttachmentManager attachmentManager, ThumbnailManager thumbnailManager, JiraAuthenticationContext authenticationContext) {
        this.attachmentManager = attachmentManager;
        this.thumbnailManager = thumbnailManager;
        this.authenticationContext = authenticationContext;
    }

    public RendererAttachment getAttachment(RenderContext context, EmbeddedResource resource) {
        Issue issue = (Issue)context.getParam((Object)"jira.issue");
        if (resource.isInternal() && issue == null || issue.getGenericValue() == null) {
            log.debug((Object)("No usable issue stored in the context, unable to resolve filename '" + resource.getFilename() + "'"));
            throw new RuntimeException("No usable issue stored in the context, unable to resolve filename '" + resource.getFilename() + "'");
        }
        Attachment attachment = null;
        Collection<Attachment> attachments = issue.getAttachments();
        for (Attachment tempAttachement : attachments) {
            if (!tempAttachement.getFilename().equals(resource.getFilename())) continue;
            attachment = tempAttachement;
            break;
        }
        if (attachment == null) {
            return null;
        }
        return this.convertToRendererAttachment(attachment, context, resource);
    }

    public RendererAttachment getThumbnail(RendererAttachment attachment, RenderContext context, EmbeddedImage image) {
        block6: {
            if (attachment != null && image.isThumbNail()) {
                try {
                    Attachment jiraAttachment = this.attachmentManager.getAttachment(new Long(attachment.getId()));
                    if (!this.thumbnailManager.isThumbnailable(jiraAttachment)) break block6;
                    try {
                        Thumbnail thumbnail = this.thumbnailManager.getThumbnail(jiraAttachment);
                        if (thumbnail != null) {
                            return this.convertToRendererAttachment(thumbnail, jiraAttachment, context, (EmbeddedResource)image);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error looking up thumbnails in RendererAttachmentManager.", (Throwable)e);
                    }
                }
                catch (GenericEntityException e) {
                    log.warn((Object)("Error resolving attachment with id: " + attachment.getId()), (Throwable)e);
                }
            }
        }
        return null;
    }

    public boolean systemSupportsThumbnailing() {
        return true;
    }

    private RendererAttachment convertToRendererAttachment(Attachment attachment, RenderContext context, EmbeddedResource resource) {
        return new RendererAttachment(attachment.getId().longValue(), attachment.getFilename(), attachment.getMimetype(), attachment.getAuthor(), null, this.buildAttachmentUrl(context, attachment), null, null, attachment.getCreated());
    }

    private RendererAttachment convertToRendererAttachment(Thumbnail thumbnail, Attachment attachment, RenderContext context, EmbeddedResource resource) {
        return new RendererAttachment(thumbnail.getAttachmentId(), thumbnail.getFilename(), attachment.getMimetype(), attachment.getAuthor(), null, this.buildThumbnailUrl(context, thumbnail), null, null, attachment.getCreated());
    }

    private String createError(RenderContext context, EmbeddedResource resource) {
        return context.addRenderedContent((Object)RenderUtils.error((RenderContext)context, (String)("Unable to resolve filename '" + resource.getFilename() + "'"), (String)this.originalLink(resource), (boolean)false));
    }

    private String originalLink(EmbeddedResource resource) {
        return "!" + resource.getOriginalLinkText() + "!";
    }

    private String buildAttachmentUrl(RenderContext context, Attachment attachment) {
        String encodedFilename;
        String encodedAttachmentId;
        try {
            encodedAttachmentId = URLCodec.encode(attachment.getId().toString(), context.getCharacterEncoding());
            encodedFilename = URLCodec.encode(attachment.getFilename(), context.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            encodedAttachmentId = attachment.getId().toString();
            encodedFilename = attachment.getFilename();
        }
        return context.getSiteRoot() + "/secure/attachment/" + encodedAttachmentId + "/" + encodedAttachmentId + "_" + encodedFilename;
    }

    private String buildThumbnailUrl(RenderContext context, Thumbnail thumbnail) {
        String encodedFilename;
        String encodedAttachmentId;
        try {
            encodedAttachmentId = URLCodec.encode(String.valueOf(thumbnail.getAttachmentId()), context.getCharacterEncoding());
            encodedFilename = URLCodec.encode(thumbnail.getFilename(), context.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            encodedAttachmentId = String.valueOf(thumbnail.getAttachmentId());
            encodedFilename = thumbnail.getFilename();
        }
        return context.getSiteRoot() + "/secure/thumbnail/" + encodedAttachmentId + "/" + encodedAttachmentId + "_" + encodedFilename;
    }
}

