/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.renderercomponent.RendererComponentFactoryDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.v2.MutableRenderer;
import com.atlassian.renderer.v2.Renderer;
import com.atlassian.renderer.v2.V2RendererFacade;
import com.atlassian.renderer.v2.components.PluggableRendererComponentFactory;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiRendererFactory {
    private static final Logger logger = LoggerFactory.getLogger(WikiRendererFactory.class);
    private final ResettableLazyReference<V2RendererFacade> wikiRendererRef = new ResettableLazyReference<V2RendererFacade>(){

        protected V2RendererFacade create() throws Exception {
            this.initializeComponents();
            return new V2RendererFacade(ComponentManager.getComponent(RendererConfiguration.class), ComponentManager.getComponent(LinkRenderer.class), ComponentManager.getComponent(EmbeddedResourceRenderer.class), ComponentManager.getComponent(Renderer.class));
        }

        private void initializeComponents() {
            ArrayList<RendererComponent> components = new ArrayList<RendererComponent>();
            MutableRenderer renderer = (MutableRenderer)ComponentManager.getComponent(Renderer.class);
            PluginAccessor pluginAccessor = ComponentManager.getComponentInstanceOfType(PluginAccessor.class);
            ArrayList descriptors = new ArrayList(pluginAccessor.getEnabledModuleDescriptorsByClass(RendererComponentFactoryDescriptor.class));
            Collections.sort(descriptors, ModuleDescriptorComparator.COMPARATOR);
            for (RendererComponentFactoryDescriptor descriptor : descriptors) {
                PluggableRendererComponentFactory rendererComponentFactory = (PluggableRendererComponentFactory)descriptor.getModule();
                if (rendererComponentFactory != null) {
                    RendererComponent rendererComponent = rendererComponentFactory.getRendererComponent();
                    if (rendererComponent != null) {
                        components.add(rendererComponent);
                        continue;
                    }
                    logger.warn("Renderer component factory " + rendererComponentFactory + " returned null renderer component");
                    continue;
                }
                logger.warn("Got null renderer component factory module from descriptor " + descriptor);
            }
            renderer.setComponents(components);
        }
    };

    public V2RendererFacade getWikiRenderer() {
        return (V2RendererFacade)this.wikiRendererRef.get();
    }

    @EventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.onPluginModuleEvent(event.getModule());
    }

    @EventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.onPluginModuleEvent(event.getModule());
    }

    private void onPluginModuleEvent(ModuleDescriptor<?> descriptor) {
        if (descriptor instanceof RendererComponentFactoryDescriptor) {
            this.wikiRendererRef.reset();
        }
    }
}

