/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.jira.plugin.renderer.MacroModuleDescriptor;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.macro.RadeoxCompatibilityMacro;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.atlassian.renderer.v2.macro.ResourceAware;
import com.atlassian.renderer.v2.macro.ResourceAwareMacroDecorator;
import java.util.Collection;

public class WikiMacroManager
implements MacroManager {
    private final PluginAccessor pluginAccessor;

    public WikiMacroManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Macro getEnabledMacro(String name) {
        if (name == null) {
            return null;
        }
        for (MacroModuleDescriptor descriptor : this.getEnabledMacroDescriptors()) {
            if (!descriptor.getKey().equals(name)) continue;
            return this.initMacro(descriptor.getModule(), descriptor);
        }
        return null;
    }

    private Macro initMacro(Object obj, MacroModuleDescriptor descriptor) {
        RadeoxCompatibilityMacro macro = null;
        if (obj instanceof org.radeox.macro.Macro) {
            macro = new RadeoxCompatibilityMacro((com.atlassian.renderer.macro.Macro)obj);
        } else if (obj instanceof Macro) {
            macro = (Macro)obj;
        }
        if (macro != null && descriptor != null) {
            if (!(macro instanceof ResourceAware)) {
                macro = new ResourceAwareMacroDecorator((Macro)macro);
            }
            ((ResourceAware)macro).setResourcePath(JiraUrlCodec.encode(descriptor.getCompleteKey()));
        }
        return macro;
    }

    private Collection getEnabledMacroDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(MacroModuleDescriptor.class);
    }
}

