/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.LazyIssueConstant;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class LazyLoadedOptionSet
implements OptionSet {
    private List<LazyIssueConstant> lazyConstants;
    private final ConstantsManager constantsManager;

    public LazyLoadedOptionSet(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
        this.lazyConstants = new ArrayList<LazyIssueConstant>(25);
    }

    @Override
    public Collection<Option> getOptions() {
        return CollectionUtils.collect(this.lazyConstants, (Transformer)new Transformer(){

            public Object transform(Object input) {
                LazyIssueConstant lazyIssueConstant = (LazyIssueConstant)input;
                return new IssueConstantOption(LazyLoadedOptionSet.this.constantsManager.getConstantObject(lazyIssueConstant.getConstantType(), lazyIssueConstant.getId()));
            }
        });
    }

    @Override
    public Collection<String> getOptionIds() {
        return CollectionUtils.collect(this.lazyConstants, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((LazyIssueConstant)input).getId();
            }
        });
    }

    @Override
    public void addOption(String constantType, String constantId) {
        this.lazyConstants.add(new LazyIssueConstant(constantType, constantId));
    }
}

