/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.option.AbstractOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class FieldConfigSchemeOption
extends AbstractOption {
    private FieldConfigScheme fieldConfigScheme;
    private List childOptions = Collections.EMPTY_LIST;

    public FieldConfigSchemeOption(FieldConfigScheme fieldConfigScheme, Collection childOptions) {
        this.fieldConfigScheme = fieldConfigScheme;
        if (childOptions != null) {
            this.childOptions = EasyList.build((Collection)childOptions);
        }
    }

    @Override
    public String getId() {
        return this.fieldConfigScheme != null ? this.fieldConfigScheme.getId().toString() : null;
    }

    public Long getFieldConfigurationId() {
        if (this.fieldConfigScheme == null || this.fieldConfigScheme.getOneAndOnlyConfig() == null) {
            return null;
        }
        return this.fieldConfigScheme.getOneAndOnlyConfig().getId();
    }

    @Override
    public String getName() {
        return this.fieldConfigScheme != null ? this.fieldConfigScheme.getName() : null;
    }

    @Override
    public String getDescription() {
        return this.fieldConfigScheme != null ? this.fieldConfigScheme.getDescription() : null;
    }

    @Override
    public List getChildOptions() {
        return this.childOptions;
    }

    public String getProjects() {
        if (this.fieldConfigScheme != null) {
            StringBuffer sb = new StringBuffer();
            if (!this.fieldConfigScheme.isGlobal()) {
                Iterator<GenericValue> iterator = this.fieldConfigScheme.getAssociatedProjects().iterator();
                while (iterator.hasNext()) {
                    GenericValue project = iterator.next();
                    sb.append(project.getString("name"));
                    if (!iterator.hasNext()) continue;
                    sb.append(", ");
                }
            } else {
                sb.append("Default scheme (unlisted projects)");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldConfigSchemeOption that = (FieldConfigSchemeOption)o;
        return !(this.fieldConfigScheme != null ? !this.fieldConfigScheme.equals(that.fieldConfigScheme) : that.fieldConfigScheme != null);
    }

    @Override
    public int hashCode() {
        return this.fieldConfigScheme != null ? this.fieldConfigScheme.hashCode() : 491;
    }
}

