/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.OptionSetManagerImpl;
import com.atlassian.jira.issue.fields.option.OptionSetPersister;
import com.atlassian.jira.util.cache.JiraCachedManager;
import com.atlassian.jira.util.cache.ManagedCache;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import java.util.Collection;
import javax.annotation.Nullable;

public class CachedOptionSetManager
implements OptionSetManager,
JiraCachedManager,
Startable {
    private final ManagedCache<FieldConfig, OptionSet> cache = ManagedCache.newManagedCache(new OptionSetForConfig(), new KeyFromFieldConfig());
    private final OptionSetManagerImpl optionSetManager;
    private final EventPublisher eventPublisher;

    public CachedOptionSetManager(OptionSetPersister optionSetPersister, ConstantsManager constantsManager, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.optionSetManager = new OptionSetManagerImpl(optionSetPersister, constantsManager);
        this.init();
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refreshCache();
    }

    public void init() {
        this.cache.clear();
    }

    @Override
    public OptionSet getOptionsForConfig(FieldConfig config) {
        return this.cache.get(Assertions.notNull("config", config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionSet createOptionSet(FieldConfig config, Collection optionIds) {
        Assertions.notNull("config", config);
        try {
            OptionSet optionSet = this.optionSetManager.createOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionSet updateOptionSet(FieldConfig config, Collection optionIds) {
        Assertions.notNull("config", config);
        try {
            OptionSet optionSet = this.optionSetManager.updateOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOptionSet(FieldConfig config) {
        Assertions.notNull("config", config);
        try {
            this.optionSetManager.removeOptionSet(config);
        }
        finally {
            this.cache.remove(config);
        }
    }

    @Override
    public long getCacheSize() {
        return this.cache.size();
    }

    @Override
    public void refreshCache() {
        this.init();
    }

    private static class KeyFromFieldConfig
    implements Function<FieldConfig, Long> {
        private KeyFromFieldConfig() {
        }

        public Long apply(@Nullable FieldConfig fieldConfig) {
            return fieldConfig.getId();
        }
    }

    private class OptionSetForConfig
    implements Function<FieldConfig, OptionSet> {
        private OptionSetForConfig() {
        }

        public OptionSet apply(@Nullable FieldConfig fieldConfig) {
            return CachedOptionSetManager.this.optionSetManager.getOptionsForConfig(fieldConfig);
        }
    }
}

