/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class FieldLayoutImpl
extends AbstractGVBean
implements FieldLayout {
    private Long id;
    private String name;
    private String description;
    private List<FieldLayoutItem> fieldLayoutItems;
    private String type;

    public FieldLayoutImpl(GenericValue genericValue, List<FieldLayoutItem> fieldLayoutItems) {
        this.fieldLayoutItems = fieldLayoutItems;
        this.setGenericValue(genericValue);
        this.init();
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.name = this.getGenericValue().getString("name");
            this.description = this.getGenericValue().getString("description");
            this.type = this.getGenericValue().getString("type");
        }
        this.setModified(false);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public boolean isDefault() {
        return "default".equals(this.getType());
    }

    protected void setId(Long id) {
        this.id = id;
    }

    protected void setInternalName(String name) {
        this.name = name;
        this.updateGV("name", name);
    }

    protected void setInternalDescription(String description) {
        this.description = description;
        this.updateGV("description", description);
    }

    @Override
    public List<FieldLayoutItem> getFieldLayoutItems() {
        return Collections.unmodifiableList(this.getInternalList());
    }

    @Override
    public FieldLayoutItem getFieldLayoutItem(OrderableField orderableField) {
        if (orderableField == null) {
            throw new IllegalArgumentException("OrderableField cannot be null.");
        }
        for (FieldLayoutItem fieldLayoutItem : this.getInternalList()) {
            if (!fieldLayoutItem.getOrderableField().equals(orderableField)) continue;
            return fieldLayoutItem;
        }
        return null;
    }

    @Override
    public FieldLayoutItem getFieldLayoutItem(String fieldId) {
        if (fieldId == null) {
            throw new IllegalArgumentException("FieldId cannot be null.");
        }
        for (int i = 0; i < this.getInternalList().size(); ++i) {
            FieldLayoutItem fieldLayoutItem = this.getInternalList().get(i);
            if (!fieldLayoutItem.getOrderableField().getId().equals(fieldId)) continue;
            return fieldLayoutItem;
        }
        return null;
    }

    @Override
    public List<FieldLayoutItem> getVisibleLayoutItems(User remoteUser, Project project, List<String> issueTypes) {
        List<FieldLayoutItem> visibleList = this.findLayout(true, project.getGenericValue(), issueTypes, new Function<FieldLayoutItem, FieldLayoutItem>(){

            @Override
            public FieldLayoutItem get(FieldLayoutItem input) {
                return input;
            }
        });
        this.orderLayoutItemsForProcessing(visibleList);
        return Collections.unmodifiableList(visibleList);
    }

    private void orderLayoutItemsForProcessing(List<FieldLayoutItem> fieldLayoutItems) {
        Iterator<FieldLayoutItem> iterator = fieldLayoutItems.iterator();
        while (iterator.hasNext()) {
            FieldLayoutItem fieldLayoutItem = iterator.next();
            if (!"assignee".equals(fieldLayoutItem.getOrderableField().getId())) continue;
            iterator.remove();
            fieldLayoutItems.add(fieldLayoutItem);
            break;
        }
    }

    @Override
    public List<FieldLayoutItem> getVisibleCustomFieldLayoutItems(Project project, List<String> issueTypes) {
        ArrayList<FieldLayoutItem> visibleCustomFieldList = new ArrayList<FieldLayoutItem>();
        for (FieldLayoutItem fieldLayoutItem : this.getInternalList()) {
            CustomField customField;
            if (!this.getFieldManager().isCustomField(fieldLayoutItem.getOrderableField()) || fieldLayoutItem.isHidden() || !(customField = (CustomField)fieldLayoutItem.getOrderableField()).isInScope(project, issueTypes)) continue;
            visibleCustomFieldList.add(fieldLayoutItem);
        }
        return visibleCustomFieldList;
    }

    @Override
    public List<Field> getHiddenFields(User remoteUser, GenericValue project, List<String> issueTypeIds) {
        return this.getHiddenFields(project, issueTypeIds);
    }

    @Override
    public List<Field> getHiddenFields(User remoteUser, Project project, List<String> issueTypeIds) {
        return this.getHiddenFields(remoteUser, project.getGenericValue(), issueTypeIds);
    }

    @Override
    public List<Field> getHiddenFields(Project project, List<String> issueTypeIds) {
        return this.getHiddenFields(project.getGenericValue(), issueTypeIds);
    }

    private List<Field> getHiddenFields(GenericValue project, List<String> issueTypeIds) {
        List<Field> result = this.findLayout(false, project, issueTypeIds, new Function<FieldLayoutItem, Field>(){

            @Override
            public Field get(FieldLayoutItem input) {
                return input.getOrderableField();
            }
        });
        result.addAll(this.getFieldManager().getUnavailableFields());
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> findLayout(boolean notHidden, GenericValue project, List<String> issueTypeIds, Function<FieldLayoutItem, T> func) {
        FieldManager fieldManager = this.getFieldManager();
        LinkedList<T> result = new LinkedList<T>();
        for (FieldLayoutItem fieldLayoutItem : this.getInternalList()) {
            if (!fieldManager.isCustomField(fieldLayoutItem.getOrderableField())) {
                if (!(fieldLayoutItem.isHidden() ^ notHidden)) continue;
                result.add(func.get(fieldLayoutItem));
                continue;
            }
            CustomField customField = (CustomField)fieldLayoutItem.getOrderableField();
            if (notHidden) {
                if (fieldLayoutItem.isHidden() || !customField.isInScope(project, issueTypeIds)) continue;
                result.add(func.get(fieldLayoutItem));
                continue;
            }
            if (!fieldLayoutItem.isHidden() && customField.isInScope(project, issueTypeIds)) continue;
            result.add(func.get(fieldLayoutItem));
        }
        return result;
    }

    protected FieldManager getFieldManager() {
        return ComponentManager.getInstance().getFieldManager();
    }

    protected HackyFieldRendererRegistry getHackyFieldRendererRegistry() {
        return ComponentManager.getComponentInstanceOfType(HackyFieldRendererRegistry.class);
    }

    @Override
    public List<FieldLayoutItem> getRequiredFieldLayoutItems(Project project, List<String> issueTypes) {
        ArrayList<FieldLayoutItem> result = new ArrayList<FieldLayoutItem>();
        for (FieldLayoutItem fieldLayoutItem : this.getInternalList()) {
            if (!fieldLayoutItem.isRequired()) continue;
            if (this.getFieldManager().isCustomField(fieldLayoutItem.getOrderableField())) {
                CustomField customField = this.getFieldManager().getCustomField(fieldLayoutItem.getOrderableField().getId());
                if (!customField.isInScope(project, issueTypes)) continue;
                result.add(fieldLayoutItem);
                continue;
            }
            result.add(fieldLayoutItem);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean isFieldHidden(String fieldId) {
        if (this.getFieldManager().isOrderableField(fieldId)) {
            FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem(this.getFieldManager().getOrderableField(fieldId));
            return fieldLayoutItem == null || fieldLayoutItem.isHidden();
        }
        return false;
    }

    @Override
    public String getRendererTypeForField(String fieldId) {
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem(this.getFieldManager().getOrderableField(fieldId));
        if (fieldLayoutItem != null) {
            return fieldLayoutItem.getRendererType();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldLayout)) {
            return false;
        }
        FieldLayout fieldLayout = (FieldLayout)o;
        return !(this.id != null ? !this.id.equals(fieldLayout.getId()) : fieldLayout.getId() != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        return result;
    }

    protected List<FieldLayoutItem> getInternalList() {
        return this.fieldLayoutItems;
    }

    void setFieldLayoutItems(List<FieldLayoutItem> fieldLayoutItems) {
        this.fieldLayoutItems = fieldLayoutItems;
    }
}

