/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItemImpl;
import java.util.ArrayList;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class EditableDefaultFieldLayoutImpl
extends FieldLayoutImpl
implements EditableDefaultFieldLayout {
    public EditableDefaultFieldLayoutImpl(GenericValue genericValue, List<FieldLayoutItem> fieldLayoutItems) {
        super(genericValue, new ArrayList<FieldLayoutItem>(fieldLayoutItems));
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            super.init();
        } else {
            this.setId(null);
            this.setName("Default Field Configuration");
            this.setDescription("The default field configuration");
        }
    }

    @Override
    public void setDescription(FieldLayoutItem fieldLayoutItem, String description) {
        String descriptionToSet = description != null && description.length() == 0 ? null : description;
        FieldLayoutItemImpl newfieldLayoutItem = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setFieldDescription(descriptionToSet).build();
        List<FieldLayoutItem> internalList = this.getInternalList();
        int pos = internalList.indexOf(fieldLayoutItem);
        internalList.set(pos, newfieldLayoutItem);
    }

    @Override
    public void setRendererType(FieldLayoutItem fieldLayoutItem, String rendererType) {
        OrderableField field = fieldLayoutItem.getOrderableField();
        if (!this.getHackyFieldRendererRegistry().shouldOverrideDefaultRenderers(field) && !this.getFieldManager().isRenderableField(field)) {
            throw new IllegalArgumentException("Trying to set a renderer on a field that is not renderable.");
        }
        FieldLayoutItemImpl newfieldLayoutItem = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setRendererType(rendererType).build();
        List<FieldLayoutItem> internalList = this.getInternalList();
        int pos = internalList.indexOf(fieldLayoutItem);
        internalList.set(pos, newfieldLayoutItem);
    }

    @Override
    public String getType() {
        return "default";
    }

    @Override
    public void show(FieldLayoutItem fieldLayoutItem) {
        if (!this.getFieldManager().isHideableField(fieldLayoutItem.getOrderableField())) {
            throw new IllegalArgumentException("Trying to show a field that is not hideable.");
        }
        FieldLayoutItemImpl fieldHide = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setHidden(false).build();
        List<FieldLayoutItem> internalList = this.getInternalList();
        int pos = internalList.indexOf(fieldLayoutItem);
        internalList.set(pos, fieldHide);
    }

    @Override
    public void hide(FieldLayoutItem fieldLayoutItem) {
        List<FieldLayoutItem> internalList = this.getInternalList();
        int hidePosition = internalList.indexOf(fieldLayoutItem);
        if (!this.getFieldManager().isHideableField(fieldLayoutItem.getOrderableField())) {
            throw new IllegalArgumentException("Trying to hide a field that is not hideable.");
        }
        FieldLayoutItemImpl.Builder builder = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setHidden(true);
        builder.setRequired(this.getFieldManager().isMandatoryField(fieldLayoutItem.getOrderableField()));
        fieldLayoutItem = builder.build();
        internalList.set(hidePosition, fieldLayoutItem);
    }

    @Override
    public void makeRequired(FieldLayoutItem fieldLayoutItem) {
        List<FieldLayoutItem> internalList = this.getInternalList();
        int requiredPosition = internalList.indexOf(fieldLayoutItem);
        if (!this.getFieldManager().isRequirableField(fieldLayoutItem.getOrderableField())) {
            throw new IllegalArgumentException("Trying to require a field that is not requireable.");
        }
        fieldLayoutItem = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setHidden(false).setRequired(true).build();
        internalList.set(requiredPosition, fieldLayoutItem);
    }

    @Override
    public void makeOptional(FieldLayoutItem fieldLayoutItem) {
        List<FieldLayoutItem> internalList = this.getInternalList();
        int optionalPositon = internalList.indexOf(fieldLayoutItem);
        if (!this.getFieldManager().isRequirableField(fieldLayoutItem.getOrderableField())) {
            throw new IllegalArgumentException("Trying to make optional a field that is not requireable.");
        }
        fieldLayoutItem = new FieldLayoutItemImpl.Builder(fieldLayoutItem).setRequired(false).build();
        internalList.set(optionalPositon, fieldLayoutItem);
    }

    @Override
    public void setName(String name) {
        this.setInternalName(name);
    }

    @Override
    public void setDescription(String description) {
        this.setInternalDescription(description);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 29 * ((Object)this.getInternalList()).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldLayout)) {
            return false;
        }
        FieldLayout fieldLayout = (FieldLayout)o;
        return super.equals(o) && ((Object)this.getFieldLayoutItems()).equals(fieldLayout.getFieldLayoutItems());
    }
}

