/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayout;
import java.util.ArrayList;
import java.util.List;

public class UserColumnLayoutImpl
extends ColumnLayoutImpl
implements UserColumnLayout {
    private final User user;

    public UserColumnLayoutImpl(List columnLayoutItems, User user) {
        super(columnLayoutItems);
        this.user = user;
    }

    public List getColumnLayoutItems() {
        FieldManager fieldManager = this.getFieldManager();
        ArrayList<ColumnLayoutItem> columnLayoutItems = new ArrayList<ColumnLayoutItem>();
        for (ColumnLayoutItem columnLayoutItem : this.getInternalList()) {
            if (fieldManager.isCustomField(columnLayoutItem.getNavigableField())) {
                CustomField customField = (CustomField)columnLayoutItem.getNavigableField();
                if (!CustomFieldUtils.isUserHasPermissionToProjects(customField, this.getUser())) continue;
                columnLayoutItems.add(columnLayoutItem);
                continue;
            }
            columnLayoutItems.add(columnLayoutItem);
        }
        return columnLayoutItems;
    }

    @Override
    public User getUser() {
        return this.user;
    }
}

