/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.EditableColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayout;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class EditableUserColumnLayoutImpl
extends EditableColumnLayoutImpl
implements EditableUserColumnLayout {
    private final User user;

    public EditableUserColumnLayoutImpl(List columnLayoutItems, User user) {
        super((List)new ArrayList(columnLayoutItems));
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public List<ColumnLayoutItem> getColumnLayoutItems() {
        FieldManager fieldManager = ManagerFactory.getFieldManager();
        LinkedList<ColumnLayoutItem> columnLayoutItems = new LinkedList<ColumnLayoutItem>();
        for (ColumnLayoutItem columnLayoutItem : this.getInternalList()) {
            if (fieldManager.isCustomField(columnLayoutItem.getNavigableField())) {
                CustomField customField = (CustomField)columnLayoutItem.getNavigableField();
                if (!CustomFieldUtils.isUserHasPermissionToProjects(customField, this.getUser())) continue;
                columnLayoutItems.add(columnLayoutItem);
                continue;
            }
            columnLayoutItems.add(columnLayoutItem);
        }
        return columnLayoutItems;
    }
}

