/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.AbstractColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.util.map.CacheObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.LRUMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultColumnLayoutManager
extends AbstractColumnLayoutManager
implements Startable {
    private static final Logger log = Logger.getLogger(AbstractColumnLayoutManager.class);
    private final Map searchRequestColumnLayoutCache;
    private final Map searchRequestColumnLayoutItemCache;
    private final EventPublisher eventPublisher;

    public DefaultColumnLayoutManager(FieldManager fieldManager, EventPublisher eventPublisher) {
        super(fieldManager);
        this.eventPublisher = eventPublisher;
        this.searchRequestColumnLayoutCache = Collections.synchronizedMap(new LRUMap(200));
        this.searchRequestColumnLayoutItemCache = Collections.synchronizedMap(new LRUMap(200));
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public ColumnLayout getColumnLayout(User remoteUser, SearchRequest searchRequest) throws ColumnLayoutStorageException {
        try {
            Set<NavigableField> availableFields = this.getFieldManager().getAvailableNavigableFields(remoteUser);
            String username = remoteUser == null ? null : remoteUser.getName();
            return new UserColumnLayoutImpl(this.getColumnLayoutItems(username, searchRequest, availableFields), remoteUser);
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields.", e);
        }
    }

    protected List getColumnLayoutItems(String username, SearchRequest searchRequest, Set availableFields) throws ColumnLayoutStorageException {
        GenericValue columnLayoutGV;
        if (searchRequest == null) {
            throw new IllegalArgumentException("Search request cannot be null.");
        }
        CacheObject cacheObject = (CacheObject)this.getSearchRequestColumnLayoutCache().get(searchRequest.getId());
        if (cacheObject != null) {
            columnLayoutGV = (GenericValue)cacheObject.getValue();
        } else {
            try {
                GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
                columnLayoutGV = EntityUtil.getOnly((List)genericDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", (Object)searchRequest.getId())));
                this.getSearchRequestColumnLayoutCache().put(searchRequest.getId(), new CacheObject<GenericValue>(columnLayoutGV));
            }
            catch (GenericEntityException e) {
                log.error((Object)e, (Throwable)e);
                throw new ColumnLayoutStorageException("Could not retrieve the Column Layout", e);
            }
        }
        if (columnLayoutGV == null) {
            return super.getColumnLayoutItems(username, availableFields);
        }
        List columnLayoutItems = (List)this.getSearchRequestColumnLayoutItemCache().get(searchRequest.getId());
        if (columnLayoutItems != null) {
            return columnLayoutItems;
        }
        try {
            columnLayoutItems = this.verifyColumnLayoutItems(columnLayoutGV, availableFields);
            this.getSearchRequestColumnLayoutItemCache().put(searchRequest.getId(), columnLayoutItems);
            return columnLayoutItems;
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve the Column Layout Items.", e);
        }
    }

    @Override
    public EditableSearchRequestColumnLayout getEditableSearchRequestColumnLayout(User user, SearchRequest searchRequest) throws ColumnLayoutStorageException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest cannot be null.");
        }
        try {
            Set<NavigableField> availableFields = this.getFieldManager().getAvailableNavigableFields(user);
            List items = this.getColumnLayoutItems(user.getName(), searchRequest, availableFields);
            return new EditableSearchRequestColumnLayoutImpl(items, user, searchRequest);
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields for user '" + user.getName() + "'.", e);
        }
    }

    @Override
    public void storeEditableSearchRequestColumnLayout(EditableSearchRequestColumnLayout editableSearchRequestColumnLayout) throws ColumnLayoutStorageException {
        SearchRequest searchRequest = editableSearchRequestColumnLayout.getSearchRequest();
        Long filterId = searchRequest.getId();
        this.storeSearchRequestColumnLayout(editableSearchRequestColumnLayout, filterId);
        this.getSearchRequestColumnLayoutCache().remove(searchRequest.getId());
        this.getSearchRequestColumnLayoutItemCache().remove(searchRequest.getId());
    }

    private void storeSearchRequestColumnLayout(ColumnLayout columnLayout, Long filterId) throws ColumnLayoutStorageException {
        try {
            GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
            GenericValue columnLayoutGV = EntityUtil.getOnly((List)genericDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", (Object)filterId)));
            if (columnLayoutGV == null) {
                columnLayoutGV = EntityUtils.createValue("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", (Object)filterId));
            }
            this.storeColumnLayoutItems(columnLayoutGV, columnLayout);
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not load ColumnLayout", e);
        }
    }

    @Override
    public void restoreSearchRequestColumnLayout(SearchRequest searchRequest) throws ColumnLayoutStorageException {
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest cannot be null.");
        }
        this.restoreSearchRequestColumnLayout(searchRequest.getId());
        this.getSearchRequestColumnLayoutCache().remove(searchRequest.getId());
        this.getSearchRequestColumnLayoutItemCache().remove(searchRequest.getId());
    }

    private void restoreSearchRequestColumnLayout(Long filterId) throws ColumnLayoutStorageException {
        try {
            GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
            GenericValue columnLayoutGV = EntityUtil.getOnly((List)genericDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", (Object)filterId)));
            if (columnLayoutGV != null) {
                this.removeColumnLayoutItems(columnLayoutGV);
            } else {
                log.warn((Object)("Search Request with id '" + filterId + "' does not have a saved column layout."));
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error removing column layout for search request with id  '" + filterId + "'."), (Throwable)e);
            throw new ColumnLayoutStorageException("Error removing column layout for search request with id  '" + filterId + "'.", e);
        }
    }

    @Override
    public boolean hasColumnLayout(SearchRequest searchRequest) throws ColumnLayoutStorageException {
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest cannot be null.");
        }
        if (!searchRequest.isLoaded()) {
            return false;
        }
        try {
            GenericValue columnLayoutGV = null;
            CacheObject cacheObject = (CacheObject)this.getSearchRequestColumnLayoutCache().get(searchRequest.getId());
            if (cacheObject != null) {
                columnLayoutGV = (GenericValue)cacheObject.getValue();
            } else {
                GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
                columnLayoutGV = EntityUtil.getOnly((List)genericDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", (Object)searchRequest.getId())));
                this.getSearchRequestColumnLayoutCache().put(searchRequest.getId(), new CacheObject<GenericValue>(columnLayoutGV));
            }
            return columnLayoutGV != null;
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException(e);
        }
    }

    @Override
    public void refresh() {
        this.getSearchRequestColumnLayoutCache().clear();
        this.getSearchRequestColumnLayoutItemCache().clear();
        super.refresh();
    }

    protected Map getSearchRequestColumnLayoutCache() {
        return this.searchRequestColumnLayoutCache;
    }

    private Map getSearchRequestColumnLayoutItemCache() {
        return this.searchRequestColumnLayoutItemCache;
    }
}

