/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManagerImpl;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersister;
import com.atlassian.jira.util.cache.JiraCachedManager;
import com.atlassian.jira.util.map.CacheObject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.keyvalue.MultiKey;

public class CachedFieldConfigSchemeManagerImpl
extends FieldConfigSchemeManagerImpl
implements JiraCachedManager,
Startable {
    private static final CacheObject<Long> NULL = new CacheObject<Object>(null);
    private final ConcurrentMap<MultiKey, CacheObject<Long>> cache = new ConcurrentHashMap<MultiKey, CacheObject<Long>>();
    private final EventPublisher eventPublisher;

    public CachedFieldConfigSchemeManagerImpl(FieldConfigSchemePersister configSchemePersister, FieldConfigContextPersister contextPersister, JiraContextTreeManager treeManager, FieldConfigManager configManager, EventPublisher eventPublisher) {
        super(configSchemePersister, contextPersister, treeManager, configManager);
        this.eventPublisher = eventPublisher;
        this.init();
    }

    @Override
    public synchronized void init() {
        super.init();
        this.cache.clear();
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.clear();
    }

    @Override
    public Object getValue(BandanaContext context, String key, boolean lookUp) {
        MultiKey multiKey = new MultiKey((Object)context, (Object)key, (Object)lookUp);
        CacheObject cacheObject = (CacheObject)this.cache.get(multiKey);
        if (cacheObject != null) {
            Long schemeId = (Long)cacheObject.getValue();
            return this.getFieldConfigSchemePersister().getFieldConfigScheme(schemeId);
        }
        FieldConfigScheme scheme = (FieldConfigScheme)super.getValue(context, key, lookUp);
        this.cache.putIfAbsent(multiKey, scheme == null ? NULL : new CacheObject<Long>(scheme.getId()));
        return scheme;
    }

    @Override
    public long getCacheSize() {
        return this.cache.size();
    }

    @Override
    public void refreshCache() {
        this.init();
    }
}

