/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountResult;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParametersImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.TimeTrackingSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.WorklogRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogWithPaginationBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.CommentSearchHandlerFactory;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.velocity.VelocityManager;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

public class WorklogSystemField
extends AbstractOrderableField
implements OrderableField,
RequirableField,
HideableField,
RenderableField,
RestFieldOperations,
RestAwareField {
    public static final String WORKLOG_TIMELOGGED = "worklog_timeLogged";
    public static final String WORKLOG_STARTDATE = "worklog_startDate";
    public static final String WORKLOG_NEWESTIMATE = "worklog_newEstimate";
    public static final String WORKLOG_ADJUSTMENTAMOUNT = "worklog_adjustmentAmount";
    public static final String WORKLOG_ADJUSTESTIMATE = "worklog_adjustEstimate";
    public static final String WORKLOG_ACTIVATE = "worklog_activate";
    public static final String WORKLOG_ID = "worklog_id";
    public static final String WORKLOG_DESCRIPTION = "worklog_description";
    public static final String WORKLOG_VISIBILITY_LEVEL = "worklog_visibilityLevel";
    private static final String WORKLOG_NAME_KEY = "issue.field.worklog";
    private static final String WORKLOG_ADD_TEMPLATE = "worklog-edit.vm";
    public static final String PARAM_ISCREATEISSUE = "isCreateIssue";
    public static final String PARAM_ISEDITLOG = "isEditLog";
    public static final String PARAM_ISDELETELOG = "isDeleteLog";
    private static final String PARAM_ISEDITISSUE = "isEditIssue";
    private static final String PARAM_COMMENT = "comment";
    private static final String PARAM_COMMENT_LEVEL = "commentLevel";
    private final ComponentLocator componentLocator;
    private final GroupManager groupManager;
    private DateTimeFormatterFactory dateTimeFormatterFactory;
    private final JiraBaseUrls jiraBaseUrls;

    public WorklogSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, CommentSearchHandlerFactory searchHandlerFactory, ComponentLocator componentLocator, GroupManager groupManager, DateTimeFormatterFactory dateTimeFormatterFactory, JiraBaseUrls jiraBaseUrls) {
        super("worklog", WORKLOG_NAME_KEY, velocityManager, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.componentLocator = componentLocator;
        this.groupManager = groupManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @Override
    public SearchHandler createAssociatedSearchHandler() {
        return null;
    }

    @Override
    protected Object getRelevantParams(Map inputParameters) {
        boolean isCreateIssue = WorklogSystemField.parseBoolean(WorklogSystemField.asArray(inputParameters, PARAM_ISCREATEISSUE));
        WorklogValue.Builder builder = new WorklogValue.Builder().setId(WorklogSystemField.asArray(inputParameters, WORKLOG_ID)).setTimeLogged(WorklogSystemField.asArray(inputParameters, WORKLOG_TIMELOGGED)).setStartDate(WorklogSystemField.asArray(inputParameters, WORKLOG_STARTDATE)).setAdjustEstimate(WorklogSystemField.asArray(inputParameters, WORKLOG_ADJUSTESTIMATE)).setNewEstimate(WorklogSystemField.asArray(inputParameters, WORKLOG_NEWESTIMATE)).setAdjustmentAmount(WorklogSystemField.asArray(inputParameters, WORKLOG_ADJUSTMENTAMOUNT)).setCreateIssue(isCreateIssue).setEditIssue(WorklogSystemField.asArray(inputParameters, PARAM_ISEDITISSUE)).setActivated(WorklogSystemField.asArray(inputParameters, WORKLOG_ACTIVATE));
        String specificComment = WorklogSystemField.fromArray(WorklogSystemField.asArray(inputParameters, WORKLOG_DESCRIPTION));
        if (StringUtils.isNotBlank((String)specificComment)) {
            builder.setComment(WorklogSystemField.asArray(inputParameters, WORKLOG_DESCRIPTION));
        } else if (isCreateIssue || this.getTimeTrackingConfiguration().copyCommentToWorkDescriptionOnTransition()) {
            builder.setComment(WorklogSystemField.asArray(inputParameters, PARAM_COMMENT));
        }
        String specificSecurity = WorklogSystemField.fromArray(WorklogSystemField.asArray(inputParameters, WORKLOG_VISIBILITY_LEVEL));
        if (StringUtils.isNotBlank((String)specificSecurity)) {
            builder.setCommentLevel(WorklogSystemField.asArray(inputParameters, WORKLOG_VISIBILITY_LEVEL));
        } else if (isCreateIssue || this.getTimeTrackingConfiguration().copyCommentToWorkDescriptionOnTransition()) {
            builder.setCommentLevel(WorklogSystemField.asArray(inputParameters, PARAM_COMMENT_LEVEL));
        }
        return builder.build();
    }

    @Override
    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        boolean isValidationRequired;
        WorklogValue value = (WorklogValue)operationContext.getFieldValuesHolder().get(this.getId());
        if (value == null) {
            return;
        }
        if (!value.isActivated()) {
            WorklogValue.Builder valueBuilder = new WorklogValue.Builder().setCreateIssue(value.isCreateIssue()).setEditIssue(value.isEditIssue());
            operationContext.getFieldValuesHolder().put(this.getId(), valueBuilder.build());
            return;
        }
        boolean bl = isValidationRequired = fieldScreenRenderLayoutItem.isRequired() || value.isSet();
        if (!isValidationRequired) {
            return;
        }
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser(), errorCollectionToAddTo, i18n);
        WorklogInputParametersImpl.Builder inputBuilder = this.getWorklogInputParams(issue, value);
        WorklogResult worklogResult = WorklogValue.AdjustEstimate.NEW == value.adjustEstimate() ? this.getWorklogService().validateCreateWithNewEstimate(jiraServiceContext, inputBuilder.buildNewEstimate()) : (WorklogValue.AdjustEstimate.MANUAL == value.adjustEstimate() ? this.getWorklogService().validateCreateWithManuallyAdjustedEstimate(jiraServiceContext, inputBuilder.buildAdjustmentAmount()) : this.getWorklogService().validateCreate(jiraServiceContext, inputBuilder.build()));
        WorklogValue.Builder updatedValue = new WorklogValue.Builder(value);
        updatedValue.setWorklogResult(worklogResult);
        operationContext.getFieldValuesHolder().put(this.getId(), updatedValue.build());
    }

    private WorklogInputParametersImpl.Builder getWorklogInputParams(Issue issue, WorklogValue value) {
        boolean editableCheckRequired = value.isEditIssue();
        CommentVisibility visibility = new CommentVisibility(value.commentLevel());
        Date parsedStartDate = WorklogValue.Builder.parseStartDate(this.getOutlookDateManager(), this.authenticationContext.getLocale(), value.startDate());
        return WorklogInputParametersImpl.issue(issue).timeSpent(value.timeLogged()).startDate(parsedStartDate).worklogId(value.id()).comment(value.comment()).groupLevel(visibility.getGroupLevel()).roleLevelId(visibility.getRoleLevel()).editableCheckRequired(editableCheckRequired).newEstimate(value.newEstimate()).adjustmentAmount(value.adjustmentAmount()).errorFieldPrefix("worklog_");
    }

    @Override
    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.populateOurVelocityParams(operationContext != null ? operationContext.getFieldValuesHolder() : null, velocityParams, issue, true, operationContext, fieldLayoutItem);
        return this.renderTemplate(WORKLOG_ADD_TEMPLATE, velocityParams);
    }

    @Override
    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.populateOurVelocityParams(operationContext != null ? operationContext.getFieldValuesHolder() : null, velocityParams, issue, false, operationContext, fieldLayoutItem);
        return this.renderTemplate(WORKLOG_ADD_TEMPLATE, velocityParams);
    }

    @Override
    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public boolean isShown(Issue issue) {
        return this.getTimeTrackingConfiguration().enabled() && this.hasPermission(issue, 20);
    }

    @Override
    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        WorklogValue.Builder builder = new WorklogValue.Builder();
        builder.setCommentLevel(null);
        builder.setAdjustEstimate(WorklogValue.AdjustEstimate.AUTO);
        fieldValuesHolder.put(this.getId(), builder.build());
    }

    @Override
    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        this.populateDefaults(fieldValuesHolder, issue);
    }

    @Override
    public Object getDefaultValue(Issue issue) {
        return null;
    }

    @Override
    public void createValue(Issue issue, Object newValue) {
        WorklogValue value = (WorklogValue)newValue;
        WorklogResult worklogResult = value.worklogResult();
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser());
        switch (value.adjustEstimate()) {
            case LEAVE: {
                this.getWorklogService().createAndRetainRemainingEstimate(jiraServiceContext, worklogResult, true);
                break;
            }
            case NEW: {
                this.getWorklogService().createWithNewRemainingEstimate(jiraServiceContext, (WorklogNewEstimateResult)worklogResult, true);
                break;
            }
            case MANUAL: {
                this.getWorklogService().createWithManuallyAdjustedEstimate(jiraServiceContext, (WorklogAdjustmentAmountResult)worklogResult, true);
                break;
            }
            default: {
                this.getWorklogService().createAndAutoAdjustRemainingEstimate(jiraServiceContext, worklogResult, true);
            }
        }
    }

    @Override
    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        WorklogValue value = (WorklogValue)modifiedValue.getNewValue();
        this.createValue(issue, value);
    }

    @Override
    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        WorklogValue value;
        if (fieldValueHolder.containsKey(this.getId()) && (value = (WorklogValue)fieldValueHolder.get(this.getId())).worklogResult() != null) {
            issue.setExternalFieldValue(this.getId(), value);
        }
    }

    @Override
    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        return new MessagedResult(false);
    }

    @Override
    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
    }

    @Override
    public void removeValueFromIssueObject(MutableIssue issue) {
        throw new UnsupportedOperationException("Remove is not done through the system field for worklogs.");
    }

    @Override
    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    @Override
    public boolean hasValue(Issue issue) {
        return false;
    }

    @Override
    public Object getValueFromParams(Map params) throws FieldValidationException {
        if (params.containsKey(this.getId())) {
            return params.get(this.getId());
        }
        return null;
    }

    @Override
    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
    }

    @Override
    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "bulk.edit.unavailable";
    }

    @Override
    public String getValueFromIssue(Issue issue) {
        return null;
    }

    @Override
    public boolean isRenderable() {
        return true;
    }

    @Override
    public RestFieldOperationsHandler getRestFieldOperation() {
        return new WorklogRestFieldOperationsHandler(this.dateTimeFormatterFactory, this.getProjectRoleManager(), this.getI18nHelper());
    }

    @Override
    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    @Override
    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray("worklog", this.getId());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser());
        List<Worklog> worklogs = this.getWorklogService().getByIssueVisibleToUser(serviceContext, issue);
        if (!serviceContext.getErrorCollection().hasAnyErrors()) {
            WorklogWithPaginationBean worklogWithPaginationBean = new WorklogWithPaginationBean();
            worklogWithPaginationBean.setMaxResults(worklogs.size());
            worklogWithPaginationBean.setTotal(worklogs.size());
            worklogWithPaginationBean.setStartAt(0);
            worklogWithPaginationBean.setWorklogs(WorklogJsonBean.asBeans(worklogs, this.jiraBaseUrls, ComponentAccessor.getUserManager(), ComponentAccessor.getComponent(TimeTrackingConfiguration.class)));
            FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData(worklogWithPaginationBean));
            if (renderedVersionRequested) {
                WorklogWithPaginationBean renderedWorklogBean = new WorklogWithPaginationBean();
                renderedWorklogBean.setMaxResults(worklogs.size());
                renderedWorklogBean.setTotal(worklogs.size());
                renderedWorklogBean.setStartAt(0);
                renderedWorklogBean.setWorklogs(WorklogJsonBean.asRenderedBeans(worklogs, this.jiraBaseUrls, fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null, issue.getIssueRenderContext()));
                fieldJsonRepresentation.setRenderedData(new JsonData(renderedWorklogBean));
            }
            return fieldJsonRepresentation;
        }
        return null;
    }

    private void populateOurVelocityParams(Map fieldValuesHolder, Map<String, Object> velocityParams, Issue issue, boolean isCreateIssue, OperationContext operationContext, FieldLayoutItem fieldLayoutItem) {
        this.populateRendererParams(velocityParams, fieldLayoutItem);
        if (fieldValuesHolder != null) {
            WorklogValue value = (WorklogValue)fieldValuesHolder.get(this.getId());
            String startDate = null;
            if (value != null) {
                velocityParams.put(this.getId(), value);
                velocityParams.put("isLogWorkActivated", value.isActivated());
                velocityParams.put("adjustEstimate", value.adjustEstimate().toString().toLowerCase());
                startDate = value.startDate();
            }
            if (StringUtils.isBlank(startDate)) {
                startDate = this.getCurrentDateTimeFormatted();
            }
            velocityParams.put("startDate", startDate);
        }
        velocityParams.put("groupLevels", this.getGroupLevels());
        if (issue != null) {
            velocityParams.put("roleLevels", this.getRoleLevels(issue));
            velocityParams.put("currentEstimate", this.getCurrentEstimate(issue));
        }
        velocityParams.put("daysPerWeek", this.getTimeTrackingConfiguration().getDaysPerWeek());
        velocityParams.put("hoursPerDay", this.getTimeTrackingConfiguration().getHoursPerDay());
        velocityParams.put("dateFormat", CustomFieldUtils.getDateFormat());
        velocityParams.put("dateTimeFormat", CustomFieldUtils.getDateTimeFormat());
        velocityParams.put("timeFormat", CustomFieldUtils.getTimeFormat());
        velocityParams.put("dateTimePicker", Boolean.TRUE);
        velocityParams.put(PARAM_ISCREATEISSUE, isCreateIssue);
        boolean isEditIssue = operationContext != null && IssueOperations.EDIT_ISSUE_OPERATION == operationContext.getIssueOperation();
        velocityParams.put(PARAM_ISEDITISSUE, isEditIssue);
        this.populateVelocityParamsForTimeTrackingProxy(fieldValuesHolder, issue, velocityParams, fieldLayoutItem);
    }

    private void populateRendererParams(Map<String, Object> velocityParams, FieldLayoutItem fieldLayoutItem) {
        String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
        velocityParams.put("rendererDescriptor", this.getRendererManager().getRendererForType(rendererType).getDescriptor());
        velocityParams.put("rendererParams", new HashMap());
    }

    private void populateVelocityParamsForTimeTrackingProxy(Map fieldValuesHolder, Issue issue, Map<String, Object> velocityParams, FieldLayoutItem worklogFieldLayoutItem) {
        boolean isTimeTrackingPresentAndShouldBeRendered = false;
        if (!worklogFieldLayoutItem.isRequired()) {
            boolean bl = isTimeTrackingPresentAndShouldBeRendered = fieldValuesHolder != null && fieldValuesHolder.containsKey("timetracking");
            if (isTimeTrackingPresentAndShouldBeRendered) {
                TimeTrackingSystemField.TimeTrackingValue value = (TimeTrackingSystemField.TimeTrackingValue)fieldValuesHolder.get("timetracking");
                if (!this.isTimeTrackingModernMode()) {
                    isTimeTrackingPresentAndShouldBeRendered = this.hasWorkStarted(issue);
                    velocityParams.put("timeTrackingFieldId", "timetracking");
                    velocityParams.put("remainingEstimateDisplayValue", value.getEstimateDisplayValue());
                } else {
                    velocityParams.put("timeTrackingFieldId", "timetracking_remainingestimate");
                    velocityParams.put("remainingEstimateDisplayValue", value.getRemainingEstimateDisplayValue());
                }
            }
        }
        velocityParams.put("isTimeTrackingPresentAndShouldBeRendered", isTimeTrackingPresentAndShouldBeRendered);
        boolean isTimeTrackingRequired = false;
        if (worklogFieldLayoutItem.getFieldLayout() != null) {
            FieldLayoutItem timeTrackingItem = worklogFieldLayoutItem.getFieldLayout().getFieldLayoutItem("timetracking");
            isTimeTrackingRequired = timeTrackingItem.isRequired();
        }
        velocityParams.put("isTimeTrackingRequired", isTimeTrackingRequired);
    }

    private boolean hasWorkStarted(Issue issue) {
        return !this.getWorklogManager().getByIssue(issue).isEmpty();
    }

    private boolean isTimeTrackingModernMode() {
        return this.getTimeTrackingConfiguration().getMode() == TimeTrackingConfiguration.Mode.MODERN;
    }

    private String getCurrentDateTimeFormatted() {
        return this.getOutlookDateManager().getOutlookDate(this.authenticationContext.getLocale()).formatDateTimePicker(new Date());
    }

    private static String[] asArray(Map inputParameters, String key) {
        return (String[])inputParameters.get(key);
    }

    private static String fromArray(String[] value) {
        return value != null && value.length > 0 ? value[0] : null;
    }

    private static boolean parseBoolean(String[] booleanArray) {
        String s = WorklogSystemField.fromArray(booleanArray);
        return StringUtils.isNotBlank((String)s) ? Boolean.valueOf(s) : false;
    }

    private static Long parseLong(String[] booleanArray) {
        String s = WorklogSystemField.fromArray(booleanArray);
        return StringUtils.isNotBlank((String)s) ? Long.valueOf(Long.parseLong(s)) : null;
    }

    private Collection<String> getGroupLevels() {
        if (this.authenticationContext.getLoggedInUser() == null || !this.getCommentService().isGroupVisiblityEnabled()) {
            return Collections.emptyList();
        }
        Collection<String> groups = this.groupManager.getGroupNamesForUser(this.authenticationContext.getLoggedInUser().getName());
        ArrayList<String> userGroups = new ArrayList<String>(groups);
        Collections.sort(userGroups);
        return userGroups;
    }

    private Collection<ProjectRole> getRoleLevels(Issue issue) {
        if (this.authenticationContext.getLoggedInUser() != null && issue != null && this.getCommentService().isProjectRoleVisiblityEnabled()) {
            return this.getProjectRoleManager().getProjectRoles(this.authenticationContext.getLoggedInUser(), issue.getProjectObject());
        }
        return Collections.emptyList();
    }

    private String getCurrentEstimate(Issue issue) {
        Long estimate = issue.getEstimate();
        return estimate == null ? null : this.getJiraDurationUtils().getFormattedDuration(estimate);
    }

    private WorklogService getWorklogService() {
        return this.componentLocator.getComponentInstanceOfType(WorklogService.class);
    }

    private TimeTrackingConfiguration getTimeTrackingConfiguration() {
        return this.componentLocator.getComponentInstanceOfType(TimeTrackingConfiguration.class);
    }

    private ProjectRoleManager getProjectRoleManager() {
        return this.componentLocator.getComponentInstanceOfType(ProjectRoleManager.class);
    }

    private I18nHelper getI18nHelper() {
        return this.componentLocator.getComponent(I18nHelper.class);
    }

    private CommentService getCommentService() {
        return this.componentLocator.getComponentInstanceOfType(CommentService.class);
    }

    private OutlookDateManager getOutlookDateManager() {
        return this.componentLocator.getComponentInstanceOfType(OutlookDateManager.class);
    }

    private JiraDurationUtils getJiraDurationUtils() {
        return this.componentLocator.getComponentInstanceOfType(JiraDurationUtils.class);
    }

    private WorklogManager getWorklogManager() {
        return this.componentLocator.getComponentInstanceOfType(WorklogManager.class);
    }

    private RendererManager getRendererManager() {
        return this.componentLocator.getComponentInstanceOfType(RendererManager.class);
    }

    public static interface WorklogValue {
        public Long id();

        public boolean isActivated();

        public String timeLogged();

        public String startDate();

        public AdjustEstimate adjustEstimate();

        public String newEstimate();

        public Long newEstimateLong();

        public String adjustmentAmount();

        public Long adjustmentAmountLong();

        public String comment();

        public String commentLevel();

        public WorklogResult worklogResult();

        public boolean isSet();

        public boolean isCreateIssue();

        public boolean isEditIssue();

        public static class Builder {
            private String timeLogged;
            private String startDate;
            private AdjustEstimate adjustEstimate = AdjustEstimate.AUTO;
            private String newEstimate;
            private Long newEstimateLong = null;
            private String adjustmentAmount;
            private Long adjustmentAmountLong = null;
            private String comment;
            private String commentLevel = null;
            private WorklogResult worklogResult = null;
            private boolean isCreateIssue = false;
            private boolean isEditIssue = false;
            private boolean isActivated = false;
            private Long id = null;

            Builder() {
            }

            Builder(WorklogValue value) {
                this.isActivated = value.isActivated();
                this.timeLogged = value.timeLogged();
                this.startDate = value.startDate();
                this.adjustEstimate = value.adjustEstimate();
                this.newEstimate = value.newEstimate();
                this.newEstimateLong = value.newEstimateLong();
                this.adjustmentAmount = value.adjustmentAmount();
                this.adjustmentAmountLong = value.adjustmentAmountLong();
                this.comment = value.comment();
                this.commentLevel = value.commentLevel();
                this.worklogResult = value.worklogResult();
                this.isCreateIssue = value.isCreateIssue();
                this.isEditIssue = value.isEditIssue();
                this.id = value.id();
            }

            Builder setActivated(String[] activated) {
                this.isActivated = WorklogSystemField.parseBoolean(activated);
                return this;
            }

            Builder setAdjustEstimate(String[] adjustEstimate) {
                String s = WorklogSystemField.fromArray(adjustEstimate);
                if (StringUtils.isNotBlank((String)s)) {
                    try {
                        this.adjustEstimate = AdjustEstimate.valueOf(s.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.adjustEstimate = null;
                    }
                }
                return this;
            }

            Builder setAdjustEstimate(AdjustEstimate adjustEstimate) {
                this.adjustEstimate = adjustEstimate;
                return this;
            }

            Builder setAdjustmentAmount(String[] adjustmentAmount) {
                this.adjustmentAmount = WorklogSystemField.fromArray(adjustmentAmount);
                return this;
            }

            Builder setAdjustmentAmountLong(Long adjustmentAmount) {
                this.adjustmentAmountLong = adjustmentAmount;
                return this;
            }

            Builder setNewEstimate(String[] newEstimate) {
                this.newEstimate = WorklogSystemField.fromArray(newEstimate);
                return this;
            }

            Builder setNewEstimateLong(Long newEstimate) {
                this.newEstimateLong = newEstimate;
                return this;
            }

            Builder setStartDate(String[] startDate) {
                this.startDate = WorklogSystemField.fromArray(startDate);
                return this;
            }

            Builder setTimeLogged(String[] timeLogged) {
                this.timeLogged = WorklogSystemField.fromArray(timeLogged);
                return this;
            }

            Builder setComment(String[] comment) {
                this.comment = WorklogSystemField.fromArray(comment);
                return this;
            }

            Builder setCommentLevel(String[] commentLevel) {
                this.commentLevel = WorklogSystemField.fromArray(commentLevel);
                return this;
            }

            Builder setWorklogResult(WorklogResult worklogResult) {
                this.worklogResult = worklogResult;
                return this;
            }

            Builder setCreateIssue(boolean createIssue) {
                this.isCreateIssue = createIssue;
                return this;
            }

            Builder setEditIssue(String[] editIssue) {
                return this.setEditIssue(WorklogSystemField.parseBoolean(editIssue));
            }

            Builder setEditIssue(boolean editIssue) {
                this.isEditIssue = editIssue;
                return this;
            }

            Builder setId(String[] strings) {
                this.id = WorklogSystemField.parseLong(strings);
                return this;
            }

            static Date parseStartDate(OutlookDateManager outlookDateManager, Locale locale, String startDate) {
                try {
                    return startDate == null ? null : outlookDateManager.getOutlookDate(locale).parseDateTimePicker(startDate);
                }
                catch (ParseException e) {
                    return null;
                }
            }

            WorklogValue build() {
                final boolean isActivated = this.isActivated;
                final String timeLogged = this.timeLogged;
                final String startDate = this.startDate;
                final AdjustEstimate adjustEstimate = this.adjustEstimate;
                final String newEstimate = this.newEstimate;
                final Long newEstimateLong = this.newEstimateLong;
                final String adjustmentAmount = this.adjustmentAmount;
                final Long adjustmentAmountLong = this.adjustmentAmountLong;
                final String comment = this.comment;
                final String commentLevel = this.commentLevel;
                final WorklogResult worklogResult = this.worklogResult;
                final boolean isCreateIssue = this.isCreateIssue;
                final boolean isEditIssue = this.isEditIssue;
                final Long id = this.id;
                return new WorklogValue(){

                    @Override
                    public boolean isActivated() {
                        return isActivated;
                    }

                    @Override
                    public String timeLogged() {
                        return timeLogged;
                    }

                    @Override
                    public String startDate() {
                        return startDate;
                    }

                    @Override
                    public AdjustEstimate adjustEstimate() {
                        return adjustEstimate;
                    }

                    @Override
                    public String newEstimate() {
                        return newEstimate;
                    }

                    @Override
                    public Long newEstimateLong() {
                        return newEstimateLong;
                    }

                    @Override
                    public String adjustmentAmount() {
                        return adjustmentAmount;
                    }

                    @Override
                    public Long adjustmentAmountLong() {
                        return adjustmentAmountLong;
                    }

                    @Override
                    public String comment() {
                        return comment;
                    }

                    @Override
                    public String commentLevel() {
                        return commentLevel;
                    }

                    @Override
                    public WorklogResult worklogResult() {
                        return worklogResult;
                    }

                    @Override
                    public boolean isSet() {
                        return StringUtils.isNotBlank((String)timeLogged) || StringUtils.isNotBlank((String)adjustmentAmount) || StringUtils.isNotBlank((String)newEstimate);
                    }

                    @Override
                    public boolean isCreateIssue() {
                        return isCreateIssue;
                    }

                    @Override
                    public boolean isEditIssue() {
                        return isEditIssue;
                    }

                    @Override
                    public Long id() {
                        return id;
                    }
                };
            }
        }

        public static enum AdjustEstimate {
            AUTO,
            LEAVE,
            NEW,
            MANUAL;

        }
    }
}

