/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.ColumnViewDateTimeHelper;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.handlers.UpdatedDateSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.DateFieldSorter;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.velocity.VelocityManager;
import java.sql.Timestamp;
import java.util.Map;

public class UpdatedSystemField
extends NavigableFieldImpl
implements SearchableField,
DateField,
RestAwareField {
    private final ColumnViewDateTimeHelper columnViewDateTimeHelper;
    private final SearchHandlerFactory searchHandlerFactory;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public UpdatedSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, UpdatedDateSearchHandlerFactory searchHandlerFactory, ColumnViewDateTimeHelper columnViewDateTimeHelper, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super("updated", "issue.field.updated", "issue.column.heading.updated", "DESC", velocityManager, applicationProperties, authenticationContext);
        this.columnViewDateTimeHelper = columnViewDateTimeHelper;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.searchHandlerFactory = Assertions.notNull("searchHandlerFactory", searchHandlerFactory);
    }

    @Override
    public LuceneFieldSorter getSorter() {
        return DateFieldSorter.ISSUE_UPDATED_STATSMAPPER;
    }

    @Override
    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        return this.columnViewDateTimeHelper.render(this, fieldLayoutItem, displayParams, issue, issue.getUpdated());
    }

    @Override
    public SearchHandler createAssociatedSearchHandler() {
        return this.searchHandlerFactory.createHandler(this);
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    @Override
    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system("datetime", "updated");
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Timestamp updated = issue.getUpdated();
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData(Dates.asTimeString(updated)));
        if (renderedVersionRequired && updated != null) {
            fieldJsonRepresentation.setRenderedData(new JsonData(this.dateTimeFormatterFactory.formatter().forLoggedInUser().format(updated)));
        }
        return fieldJsonRepresentation;
    }
}

