/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.statistics.SubTaskStatisticsMapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.velocity.VelocityManager;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class SubTaskSystemField
extends NavigableFieldImpl
implements RestAwareField {
    private final IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory;
    private final SubTaskStatisticsMapper subTaskStatisticsMapper;

    public SubTaskSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, SubTaskStatisticsMapper subTaskStatisticsMapper, IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory) {
        super("subtasks", "issue.field.subtasks", "issue.column.heading.subtasks", "ASC", velocityManager, applicationProperties, authenticationContext);
        this.subTaskStatisticsMapper = subTaskStatisticsMapper;
        this.issueLinkBeanBuilderFactory = issueLinkBeanBuilderFactory;
    }

    @Override
    public LuceneFieldSorter getSorter() {
        return this.subTaskStatisticsMapper;
    }

    @Override
    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("subtasks", issue.getSubTaskObjects());
        velocityParams.put("applicationProperties", this.getApplicationProperties());
        return this.renderTemplate("subtask-columnview.vm", velocityParams);
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    @Override
    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray("issuelinks", this.getId());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        IssueLinksBeanBuilder issueLinkBeanBuilder = this.issueLinkBeanBuilderFactory.newIssueLinksBeanBuilder(issue);
        List<IssueRefJsonBean> subtaskLinks = issueLinkBeanBuilder.buildSubtaskLinks();
        if (subtaskLinks != null) {
            return new FieldJsonRepresentation(new JsonData(subtaskLinks));
        }
        return null;
    }
}

