/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.handlers.StatusSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.StatusStatisticsMapper;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class StatusSystemField
extends NavigableFieldImpl
implements SearchableField,
RestAwareField {
    private final StatusStatisticsMapper statusStatisticsMapper;
    private final ConstantsManager constantsManager;
    private final SearchHandlerFactory searchHandlerFactory;
    private final JiraBaseUrls jiraBaseUrls;

    public StatusSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, StatusStatisticsMapper statusStatisticsMapper, ConstantsManager constantsManager, StatusSearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls) {
        super("status", "issue.field.status", "issue.column.heading.status", "DESC", velocityManager, applicationProperties, authenticationContext);
        this.statusStatisticsMapper = statusStatisticsMapper;
        this.constantsManager = constantsManager;
        this.searchHandlerFactory = searchHandlerFactory;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @Override
    public LuceneFieldSorter getSorter() {
        return this.statusStatisticsMapper;
    }

    @Override
    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        Status status = issue.getStatusObject();
        velocityParams.put(this.getId(), status);
        return this.renderTemplate("status-columnview.vm", velocityParams);
    }

    private Long getStatusTypeIdByName(String stringValue) throws FieldValidationException {
        for (GenericValue statusGV : this.constantsManager.getStatuses()) {
            if (!stringValue.equalsIgnoreCase(statusGV.getString("name"))) continue;
            return Long.valueOf(statusGV.getString("id"));
        }
        throw new FieldValidationException("Invalid status name '" + stringValue + "'.");
    }

    @Override
    public SearchHandler createAssociatedSearchHandler() {
        return this.searchHandlerFactory.createHandler(this);
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        Status status;
        Long statusId;
        if (TextUtils.stringSet((String)changeHistory) && (statusId = this.getStatusTypeIdByName(changeHistory)) != null && (status = this.constantsManager.getStatusObject(statusId.toString())) != null) {
            return status.getNameTranslation(i18nHelper);
        }
        return changeHistory;
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        ArrayList<Status> statusConstants = new ArrayList<Status>();
        Collection<Status> statuses = this.constantsManager.getStatusObjects();
        for (GenericValue genericValue : statuses) {
            Status status = this.constantsManager.getStatusObject(genericValue.getString("id"));
            statusConstants.add(status);
        }
        return new FieldTypeInfo(statusConstants, null);
    }

    @Override
    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system("status", "status");
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData(StatusJsonBean.bean(issue.getStatusObject(), this.jiraBaseUrls)));
    }
}

