/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.impl.rest.TextCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldClauseContextHandler;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldClauseSanitiserHandler;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.customfields.view.NullCustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.IssueComparator;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.constants.DefaultClauseInformation;
import com.atlassian.jira.issue.search.parameters.lucene.sort.DefaultIssueSortComparator;
import com.atlassian.jira.issue.search.parameters.lucene.sort.DocumentSortComparatorSource;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.DefaultValuesGeneratingClauseHandler;
import com.atlassian.jira.jql.NoOpClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.CustomFieldClauseContextFactory;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.ClauseSanitiser;
import com.atlassian.jira.jql.permission.CustomFieldClausePermissionChecker;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkMoveHelper;
import com.atlassian.jira.web.bean.DefaultBulkMoveHelper;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.apache.lucene.search.FieldComparatorSource;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class CustomFieldImpl
implements CustomField {
    private static final Logger log = Logger.getLogger(CustomFieldImpl.class);
    private final GenericValue gv;
    private final LazyReference<CustomFieldType> typeRef = new CustomFieldTypeLazyRef();
    private final LazyReference<CustomFieldSearcher> searcherRef = new CustomFieldSearcherLazyRef();
    private final AtomicReference<List<FieldConfigScheme>> configurationSchemes = new AtomicReference<Object>(null);
    private final JiraAuthenticationContext authenticationContext;
    private final CustomFieldManager customFieldManager;
    private final ConstantsManager constantsManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final PermissionManager permissionManager;
    private final RendererManager rendererManager;
    private final FieldConfigSchemeClauseContextUtil contextUtil;
    private final String customFieldId;

    public CustomFieldImpl(GenericValue customField, CustomFieldManager customFieldManager, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, FieldConfigSchemeManager fieldConfigSchemeManager, PermissionManager permissionManager, RendererManager rendererManager, FieldConfigSchemeClauseContextUtil contextUtil) {
        this.customFieldManager = customFieldManager;
        this.gv = customField;
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.permissionManager = permissionManager;
        this.rendererManager = rendererManager;
        this.contextUtil = contextUtil;
        this.customFieldId = "customfield_" + this.gv.getLong("id");
    }

    @Override
    public void store() throws DataAccessException {
        try {
            this.gv.store();
            ComponentManager.getComponentInstanceOfType(FieldManager.class).refresh();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Exception whilst trying to store genericValue " + this.gv + ".", e);
        }
    }

    @Override
    public boolean isInScope(Project project, List<String> issueTypeIds) {
        List<IssueContext> issueContexts = CustomFieldUtils.convertToIssueContexts(project, issueTypeIds);
        return this.isInScope(issueContexts);
    }

    public final boolean isInScope(GenericValue project, List issueTypeIds) {
        List<IssueContext> issueContexts = CustomFieldUtils.convertToIssueContexts(project, (List<String>)issueTypeIds);
        return this.isInScope(issueContexts);
    }

    private boolean isInScope(List<IssueContext> issueContexts) {
        for (IssueContext issueContext : issueContexts) {
            FieldConfig relevantConfig = this.getRelevantConfig(issueContext);
            if (relevantConfig == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public FieldConfig getReleventConfig(SearchContext searchContext) {
        List<IssueContext> issueContexts = searchContext.getAsIssueContexts();
        FieldConfig config = null;
        boolean firstRun = true;
        for (IssueContext issueContext : issueContexts) {
            FieldConfig relevantConfig = this.getRelevantConfig(issueContext);
            if (firstRun) {
                config = relevantConfig;
                firstRun = false;
                continue;
            }
            if (!CustomFieldImpl.areDifferent(config, relevantConfig)) continue;
            log.debug((Object)("Different configs found for search context. No configs are returned for " + this.getName()));
            return null;
        }
        return config;
    }

    @Override
    public ClauseNames getClauseNames() {
        return ClauseNames.forCustomField(this);
    }

    @Override
    public boolean isInScope(SearchContext searchContext) {
        return this.getReleventConfig(searchContext) != null;
    }

    @Override
    public final boolean isInScope(User user, SearchContext searchContext) {
        return this.getReleventConfig(searchContext) != null;
    }

    @Override
    public void validateFromActionParams(Map actionParameters, ErrorCollection errorCollection, FieldConfig config) {
        CustomFieldParams relevantParams = this.getRelevantParams(actionParameters);
        this.getCustomFieldType().validateFromParams(relevantParams, errorCollection, config);
    }

    @Override
    public Object getValue(Issue issue) {
        return this.getCustomFieldType().getValueFromIssue(this, issue);
    }

    @Override
    public boolean isRenderable() {
        return this.getCustomFieldType().isRenderable();
    }

    @Nullable
    private String getChangelogValue(Object value) {
        return this.getCustomFieldType().getChangelogValue(this, value);
    }

    @Nullable
    private String getChangelogString(Object value) {
        return this.getCustomFieldType().getChangelogString(this, value);
    }

    @Override
    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        ChangeItemBean changeItemBean = this.updateValue(fieldLayoutItem, issue, modifiedValue.getNewValue());
        if (changeItemBean != null) {
            issueChangeHolder.addChangeItem(changeItemBean);
        }
    }

    private ChangeItemBean updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, Object newValue) {
        Object existingValue = this.getValue(issue);
        ChangeItemBean cib = null;
        if (existingValue == null) {
            if (newValue != null) {
                newValue = this.processValueThroughRenderer(fieldLayoutItem, newValue);
                this.createValue(issue, newValue);
                String changelogValue = this.getChangelogValue(newValue);
                if (changelogValue != null) {
                    String changelogString = this.getChangelogString(newValue);
                    if (changelogString == null) {
                        changelogString = changelogValue;
                        changelogValue = null;
                    }
                    cib = new ChangeItemBean("custom", this.getNameKey(), null, null, changelogValue, changelogString);
                }
            }
        } else if (!this.valuesEqual(existingValue, newValue)) {
            newValue = this.processValueThroughRenderer(fieldLayoutItem, newValue);
            this.getCustomFieldType().updateValue(this, issue, newValue);
            String changelogValue = this.getChangelogValue(newValue);
            if (changelogValue != null) {
                String changelogString = this.getChangelogString(newValue);
                if (changelogString == null) {
                    changelogString = changelogValue;
                    changelogValue = null;
                }
                String oldChangelogString = this.getChangelogString(existingValue);
                String oldChangelogValue = this.getChangelogValue(existingValue);
                if (oldChangelogString == null) {
                    oldChangelogString = oldChangelogValue;
                    oldChangelogValue = null;
                }
                cib = new ChangeItemBean("custom", this.getNameKey(), oldChangelogValue, oldChangelogString, changelogValue, changelogString);
            }
        }
        return cib;
    }

    private Object processValueThroughRenderer(FieldLayoutItem fieldLayoutItem, Object value) {
        if (this.isRenderable()) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            value = this.rendererManager.getRendererForType(rendererType).transformFromEdit(value);
        }
        return value;
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory) {
        return changeHistory;
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        return changeHistory;
    }

    @Override
    public boolean isEditable() {
        return this.getCustomFieldType().getDescriptor().isEditTemplateExists();
    }

    @Override
    public Options getOptions(String key, JiraContextNode jiraContextNode) {
        return this.getOptions(key, this.getRelevantConfig(jiraContextNode), jiraContextNode);
    }

    @Override
    public Options getOptions(String key, FieldConfig config, JiraContextNode contextNode) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof MultipleCustomFieldType) {
            MultipleCustomFieldType multipleCustomFieldType = (MultipleCustomFieldType)customFieldType;
            return multipleCustomFieldType.getOptions(config, contextNode);
        }
        return null;
    }

    @Override
    public void populateDefaults(Map customFieldValuesHolder, Issue issue) {
        FieldConfig config = this.getRelevantConfig(issue);
        if (config != null) {
            Object defaultValues = this.getCustomFieldType().getDefaultValue(config);
            if (defaultValues != null) {
                CustomFieldParamsImpl paramsFromIssue = new CustomFieldParamsImpl(this, defaultValues);
                paramsFromIssue.transformObjectsToStrings();
                customFieldValuesHolder.put(this.getId(), paramsFromIssue);
                customFieldValuesHolder.put(this.getId() + ":objects", new CustomFieldParamsImpl(this, defaultValues));
            }
        } else {
            log.info((Object)("No relevant config found for " + this + " for the issue " + issue));
        }
    }

    @Override
    public FieldConfig getRelevantConfig(IssueContext issueContext) {
        return this.fieldConfigSchemeManager.getRelevantConfig(issueContext, this);
    }

    @Override
    public FieldConfig getRelevantConfig(Issue issue) {
        return this.getRelevantConfig((IssueContext)issue);
    }

    private FieldConfig getRelevantConfig(JiraContextNode contextNode) {
        return this.getRelevantConfig(new IssueContextImpl(contextNode.getProjectObject(), contextNode.getIssueTypeObject()));
    }

    @Override
    public boolean hasParam(Map parameters) {
        CustomFieldParams relevantParams = this.getRelevantParams(parameters);
        return !relevantParams.isEmpty();
    }

    @Override
    public void populateFromParams(Map customFieldValuesHolder, Map params) {
        CustomFieldParams relevantParams = this.getRelevantParams(params);
        customFieldValuesHolder.put(this.getId(), relevantParams);
    }

    @Override
    public void populateFromIssue(Map customFieldValuesHolder, Issue issue) {
        CustomFieldParams paramsFromIssue = this.getCustomFieldParamsFromIssue(issue);
        customFieldValuesHolder.put(this.getId(), paramsFromIssue);
    }

    @Override
    public Object getValueFromParams(Map params) throws FieldValidationException {
        return this.getCustomFieldType().getValueFromCustomFieldParams((CustomFieldParams)params.get(this.getId()));
    }

    @Override
    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public List getConfigurationItemTypes() {
        return this.getCustomFieldType().getConfigurationItemTypes();
    }

    @Override
    public SearchHandler createAssociatedSearchHandler() {
        ClauseContextFactory clauseContextFactory;
        CustomFieldSearcher customFieldSearcher = this.getCustomFieldSearcher();
        ClauseNames clauseNames = this.getClauseNames();
        if (customFieldSearcher == null) {
            if (this.getCustomFieldType() instanceof SortableCustomField) {
                NoOpClauseHandler noOpClauseHandler = new NoOpClauseHandler(this.createClausePermissionHandler(null), this.getId(), clauseNames, "jira.jql.validation.field.not.searchable");
                SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(noOpClauseHandler);
                return new SearchHandler(Collections.<FieldIndexer>emptyList(), null, Collections.singletonList(clauseRegistration));
            }
            return null;
        }
        CustomFieldSearcherClauseHandler searcherClauseHandler = customFieldSearcher.getCustomFieldSearcherClauseHandler();
        if (searcherClauseHandler instanceof CustomFieldClauseContextHandler) {
            clauseContextFactory = ((CustomFieldClauseContextHandler)((Object)searcherClauseHandler)).getClauseContextFactory();
        } else {
            FieldConfigSchemeClauseContextUtil clauseContextUtil = ComponentManager.getComponentInstanceOfType(FieldConfigSchemeClauseContextUtil.class);
            clauseContextFactory = new CustomFieldClauseContextFactory(this, clauseContextUtil, ContextSetUtil.getInstance());
        }
        ClauseSanitiser sanitiser = null;
        if (searcherClauseHandler instanceof CustomFieldClauseSanitiserHandler) {
            sanitiser = ((CustomFieldClauseSanitiserHandler)((Object)searcherClauseHandler)).getClauseSanitiser();
        }
        DefaultClauseInformation clauseInformation = new DefaultClauseInformation(this.getId(), clauseNames, this.getId(), searcherClauseHandler.getSupportedOperators(), searcherClauseHandler.getDataType());
        ClauseHandler customFieldClauseHandler = searcherClauseHandler instanceof ValueGeneratingClauseHandler ? new DefaultValuesGeneratingClauseHandler(clauseInformation, searcherClauseHandler.getClauseQueryFactory(), searcherClauseHandler.getClauseValidator(), this.createClausePermissionHandler(sanitiser), clauseContextFactory, ((ValueGeneratingClauseHandler)((Object)searcherClauseHandler)).getClauseValuesGenerator()) : new DefaultClauseHandler(clauseInformation, searcherClauseHandler.getClauseQueryFactory(), searcherClauseHandler.getClauseValidator(), this.createClausePermissionHandler(sanitiser), clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(customFieldClauseHandler);
        return new SearchHandler(customFieldSearcher.getSearchInformation().getRelatedIndexers(), new SearchHandler.SearcherRegistration(customFieldSearcher, clauseRegistration));
    }

    private ClausePermissionHandler createClausePermissionHandler(ClauseSanitiser sanitiser) {
        CustomFieldClausePermissionChecker.Factory factory = ComponentManager.getComponentInstanceOfType(CustomFieldClausePermissionChecker.Factory.class);
        ClausePermissionChecker checker = factory.createPermissionChecker(this, this.contextUtil);
        if (sanitiser == null) {
            return new DefaultClausePermissionHandler(checker);
        }
        return new DefaultClausePermissionHandler(checker, sanitiser);
    }

    @Override
    public void createValue(Issue issue, Object value) {
        if (value != null) {
            this.getCustomFieldType().createValue(this, issue, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map params = operationContext.getFieldValuesHolder();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        FieldConfig config = this.getRelevantConfig(issue);
        if (params.containsKey(this.getId())) {
            this.getCustomFieldType().validateFromParams((CustomFieldParams)params.get(this.getId()), errorCollection, config);
        }
        if (!errorCollection.hasAnyErrors()) {
            try {
                if (!this.isEditable() || fieldScreenRenderLayoutItem == null || !fieldScreenRenderLayoutItem.isRequired() || params.containsKey(this.getId()) && this.getCustomFieldType().getValueFromCustomFieldParams((CustomFieldParams)params.get(this.getId())) != null) return;
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", this.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
            catch (FieldValidationException e) {
                log.error((Object)"Error occurred while validating a custom field", (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            errorCollectionToAddTo.addErrorCollection(errorCollection);
        }
    }

    @Override
    public CustomFieldParams getCustomFieldValues(Map customFieldValuesHolder) {
        if (customFieldValuesHolder == null) {
            return new NullCustomFieldParams();
        }
        CustomFieldParams customFieldParams = (CustomFieldParams)customFieldValuesHolder.get(this.getId());
        if (customFieldParams == null) {
            return new NullCustomFieldParams();
        }
        return customFieldParams;
    }

    @Override
    public Set<Long> remove() throws DataAccessException {
        CustomFieldType customFieldType = this.getCustomFieldType();
        Set<Long> issueIds = customFieldType != null ? customFieldType.remove(this) : Collections.emptySet();
        try {
            this.gv.remove();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        return issueIds;
    }

    protected CustomFieldParams getRelevantParams(Map params) {
        CustomFieldParamsImpl customFieldParams = new CustomFieldParamsImpl(this);
        for (Map.Entry entry : params.entrySet()) {
            String[] p;
            String key = (String)entry.getKey();
            String customFieldKey = CustomFieldUtils.getCustomFieldKey(key);
            if (key == null || !this.getId().equals(customFieldKey) || (p = (String[])entry.getValue()) == null || p.length <= 0) continue;
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == null || p[i].length() <= 0) continue;
                customFieldParams.addValue(CustomFieldUtils.getSearchParamSuffix(key), Arrays.asList(p));
                i = p.length;
            }
        }
        return customFieldParams;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Object customFieldValue = this.getRendererCustomFieldValue(fieldLayoutItem, issue, displayParams);
        return this.getCustomFieldType().getDescriptor().getColumnViewHtml(this, customFieldValue, issue, displayParams, fieldLayoutItem);
    }

    private Object getRendererCustomFieldValue(FieldLayoutItem fieldLayoutItem, Issue issue, Map displayParams) {
        Object customFieldValue = this.isRenderable() && displayParams.get("excel_view") == null ? this.rendererManager.getRenderedContent(fieldLayoutItem, issue) : issue.getCustomFieldValue(this);
        return customFieldValue;
    }

    private Object getRendererCustomFieldValue(FieldLayoutItem fieldLayoutItem, Issue issue, Object value) {
        Object customFieldValue;
        if (this.isRenderable() && value instanceof String) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            customFieldValue = this.rendererManager.getRenderedContent(rendererType, (String)value, issue.getIssueRenderContext());
        } else {
            customFieldValue = value;
        }
        return customFieldValue;
    }

    protected I18nHelper getI18nHelper() {
        return this.getCustomFieldType().getDescriptor().getI18nBean();
    }

    @Override
    public String getHiddenFieldId() {
        return this.getId();
    }

    @Override
    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getCreateHtml(fieldLayoutItem, operationContext, action, issue, new HashMap());
    }

    @Override
    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map dispayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, dispayParameters);
    }

    @Override
    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, new HashMap());
    }

    @Override
    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map dispayParameters) {
        return this.getCustomFieldType().getDescriptor().getEditHtml(this.getRelevantConfig(issue), operationContext.getFieldValuesHolder(), issue, action, dispayParameters, fieldLayoutItem);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Assertions.notNull("bulkEditBean", bulkEditBean);
        Assertions.notEmpty("selectedIssues", bulkEditBean.getSelectedIssues());
        FieldLayoutItem fieldLayoutItem = null;
        if (bulkEditBean.getTargetFieldLayout() != null) {
            fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem(this);
            if (this.isCustomFieldTypeSupportedForDistinctValueMapping(fieldLayoutItem)) {
                return this.getBulkMoveHtmlWithMapping(fieldLayoutItem, operationContext, action, bulkEditBean, displayParameters);
            }
            return this.getEditHtml(fieldLayoutItem, operationContext, action, bulkEditBean.getFirstTargetIssueObject(), displayParameters);
        }
        if (!bulkEditBean.getFieldLayouts().isEmpty()) {
            fieldLayoutItem = bulkEditBean.getFieldLayouts().iterator().next().getFieldLayoutItem(this);
        }
        return this.getEditHtml(fieldLayoutItem, operationContext, action, bulkEditBean.getSelectedIssues().iterator().next(), displayParameters);
    }

    private String getBulkMoveHtmlWithMapping(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Issue issue = bulkEditBean.getFirstTargetIssueObject();
        DefaultBulkMoveHelper bulkMoveHelper = new DefaultBulkMoveHelper();
        Function<Issue, Collection<Object>> issueValueResolver = new Function<Issue, Collection<Object>>(){

            @Override
            public Collection<Object> get(Issue issue) {
                LinkedHashMap fieldValuesHolder = new LinkedHashMap();
                CustomFieldImpl.this.populateFromIssue(fieldValuesHolder, issue);
                Object o = fieldValuesHolder.get(CustomFieldImpl.this.getId());
                CustomFieldParams customFieldParams = (CustomFieldParams)o;
                return customFieldParams.getAllValues();
            }
        };
        Function<Object, String> nameResolver = new Function<Object, String>(){

            @Override
            public String get(Object input) {
                Object result = CustomFieldImpl.this.getCustomFieldType().getSingularObjectFromString((String)input);
                if (result == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Could not resolve name for input '" + input + "'."));
                    }
                } else {
                    if (result instanceof Version) {
                        return ((Version)result).getName();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Type '" + result.getClass() + "' currently not supported for bulk move."));
                    }
                }
                return null;
            }
        };
        Map<Long, BulkMoveHelper.DistinctValueResult> distinctValues = bulkMoveHelper.getDistinctValuesForMove(bulkEditBean, this, issueValueResolver, nameResolver);
        return this.getCustomFieldType().getDescriptor().getBulkMoveHtml(this.getRelevantConfig(issue), operationContext.getFieldValuesHolder(), issue, action, displayParameters, fieldLayoutItem, distinctValues, bulkMoveHelper);
    }

    private boolean isCustomFieldTypeSupportedForDistinctValueMapping(FieldLayoutItem fieldLayoutItem) {
        CustomField customField = (CustomField)fieldLayoutItem.getOrderableField();
        return customField.getCustomFieldType() instanceof VersionCFType;
    }

    @Override
    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue) {
        return this.getViewHtml(fieldLayoutItem, action, issue, new HashMap());
    }

    @Override
    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        return this.getCustomFieldType().getDescriptor().getViewHtml(this, this.getRendererCustomFieldValue(fieldLayoutItem, issue, displayParameters), issue, fieldLayoutItem, displayParameters);
    }

    @Override
    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        return this.getCustomFieldType().getDescriptor().getViewHtml(this, this.getRendererCustomFieldValue(fieldLayoutItem, issue, value), issue, fieldLayoutItem, displayParameters);
    }

    @Override
    public boolean isShown(Issue issue) {
        return true;
    }

    @Override
    public Object getDefaultValue(Issue issue) {
        FieldConfig config = this.getRelevantConfig(issue);
        return this.getCustomFieldType().getDefaultValue(config);
    }

    @Override
    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        try {
            if (fieldValueHolder.containsKey(this.getId())) {
                CustomFieldParams customFieldParams = (CustomFieldParams)fieldValueHolder.get(this.getId());
                issue.setCustomFieldValue(this, this.getCustomFieldType().getValueFromCustomFieldParams(customFieldParams));
            }
        }
        catch (FieldValidationException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            String targetRendererType;
            String rendererType;
            if (!this.isInScope(originalIssue.getProjectObject(), (List<String>)ImmutableList.of((Object)originalIssue.getIssueTypeObject().getId()))) {
                return new MessagedResult(true);
            }
            if (!this.doesFieldHaveValue(originalIssue) && targetFieldLayoutItem != null && targetFieldLayoutItem.isRequired()) {
                return new MessagedResult(true);
            }
            if (this.doesFieldHaveValue(originalIssue)) {
                CustomFieldParams customFieldParams = this.getCustomFieldParamsFromIssue(originalIssue);
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                FieldConfig config = this.getRelevantConfig(targetIssue);
                if (this.getCustomFieldType() instanceof VersionCFType && !originalIssue.getProject().getLong("id").equals(targetIssue.getProject().getLong("id"))) {
                    return new MessagedResult(true);
                }
                this.getCustomFieldType().validateFromParams(customFieldParams, errorCollection, config);
                if (errorCollection.hasAnyErrors()) {
                    log.debug((Object)("Move required. Errors occurred in automatic moving: " + ToStringBuilder.reflectionToString(errorCollection.getErrorMessages())));
                    return new MessagedResult(true);
                }
            }
            if (!this.isRenderable() || !this.doesFieldHaveValue(originalIssue)) continue;
            FieldLayoutItem fieldLayoutItem = null;
            try {
                fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(originalIssue.getProjectObject(), originalIssue.getIssueTypeObject().getId()).getFieldLayoutItem(this.getId());
            }
            catch (DataAccessException e) {
                log.warn((Object)(this.getName() + " field was unable to resolve the field layout item for issue " + originalIssue.getId()), (Throwable)e);
            }
            if (this.rendererTypesEqual(rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null, targetRendererType = targetFieldLayoutItem != null ? targetFieldLayoutItem.getRendererType() : null)) continue;
            if (originalIssues.size() > 1) {
                return new MessagedResult(false, this.getI18nHelper().getText("renderer.bulk.move.warning"), 1);
            }
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    @Override
    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        if (this.isRenderable()) {
            fieldValuesHolder.put(this.getId(), this.getCustomFieldParamsFromIssue(originalIssue));
        } else {
            this.populateDefaults(fieldValuesHolder, targetIssue);
        }
    }

    @Override
    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setCustomFieldValue(this, null);
    }

    @Override
    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    @Override
    public boolean hasValue(Issue issue) {
        return this.getValue(issue) != null;
    }

    private boolean doesFieldHaveValue(Issue issue) {
        Object value = this.getValue(issue);
        if (value != null && this.getCustomFieldType() instanceof LabelsCFType && value instanceof Collection) {
            Collection c = (Collection)value;
            return !c.isEmpty();
        }
        return value != null;
    }

    @Override
    public String getId() {
        return this.customFieldId;
    }

    @Override
    public String getValueFromIssue(Issue issue) {
        Object value = this.getValue(issue);
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    @Override
    public Long getIdAsLong() {
        return this.gv.getLong("id");
    }

    @Override
    public List<FieldConfigScheme> getConfigurationSchemes() {
        return this.configurationSchemes.get();
    }

    public void setConfigurationSchemes(List<FieldConfigScheme> configurationSchemes) {
        this.configurationSchemes.set(configurationSchemes);
    }

    @Override
    public String getNameKey() {
        return this.gv.getString("name");
    }

    private CustomFieldParams getCustomFieldParamsFromIssue(Issue issue) {
        CustomFieldParamsImpl paramsFromIssue = new CustomFieldParamsImpl(this);
        Object valueFromIssue = this.getCustomFieldType().getValueFromIssue(this, issue);
        if (valueFromIssue != null) {
            paramsFromIssue = new CustomFieldParamsImpl(this, valueFromIssue);
            paramsFromIssue.transformObjectsToStrings();
        }
        return paramsFromIssue;
    }

    @Override
    public List<GenericValue> getAssociatedProjectCategories() {
        LinkedList<GenericValue> projectCategories = null;
        List<FieldConfigScheme> configurations = this.getConfigurationSchemes();
        if (configurations != null) {
            projectCategories = new LinkedList<GenericValue>();
            for (FieldConfigScheme config : configurations) {
                List<GenericValue> configProject = config.getAssociatedProjectCategories();
                if (configProject == null) continue;
                projectCategories.addAll(configProject);
            }
            Collections.sort(projectCategories, OfBizComparators.NAME_COMPARATOR);
        }
        return projectCategories;
    }

    @Override
    public List<GenericValue> getAssociatedProjects() {
        List<FieldConfigScheme> configurations = this.getConfigurationSchemes();
        LinkedList<GenericValue> projects = null;
        if (configurations != null) {
            projects = new LinkedList<GenericValue>();
            for (FieldConfigScheme config : configurations) {
                List<GenericValue> configProject = config.getAssociatedProjects();
                if (configProject == null) continue;
                projects.addAll(configProject);
            }
            Collections.sort(projects, OfBizComparators.NAME_COMPARATOR);
        }
        return projects;
    }

    @Override
    public List<GenericValue> getAssociatedIssueTypes() {
        List<FieldConfigScheme> configurations = this.getConfigurationSchemes();
        ArrayList issueTypes = null;
        if (configurations != null) {
            HashSet<GenericValue> issueTypesSet = new HashSet<GenericValue>();
            for (FieldConfigScheme config : configurations) {
                Set<GenericValue> configIssueType = config.getAssociatedIssueTypes();
                if (configIssueType == null) continue;
                issueTypesSet.addAll(configIssueType);
            }
            issueTypes = new ArrayList(issueTypesSet);
            Collections.sort(issueTypes, OfBizComparators.NAME_COMPARATOR);
        }
        return issueTypes;
    }

    @Override
    public boolean isGlobal() {
        return this.isAllProjects() && this.isAllIssueTypes();
    }

    @Override
    public boolean isAllProjects() {
        List<FieldConfigScheme> configurations = this.getConfigurationSchemes();
        if (configurations != null) {
            for (FieldConfigScheme configuration : configurations) {
                if (!configuration.isAllProjects()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAllIssueTypes() {
        List<GenericValue> issueTypes = this.getAssociatedIssueTypes();
        return issueTypes != null && issueTypes.contains(null);
    }

    @Override
    public boolean isEnabled() {
        List<FieldConfigScheme> configurations = this.getConfigurationSchemes();
        if (configurations != null) {
            for (FieldConfigScheme config : configurations) {
                if (!config.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        String customFieldAvailabilityString = customFieldType.availableForBulkEdit(bulkEditBean);
        if (TextUtils.stringSet((String)customFieldAvailabilityString)) {
            return customFieldAvailabilityString;
        }
        for (FieldLayout o : bulkEditBean.getFieldLayouts()) {
            FieldLayout fieldLayout = o;
            if (!fieldLayout.isFieldHidden(this.getId())) continue;
            return "bulk.edit.unavailable.hidden";
        }
        FieldConfig config = null;
        boolean first = true;
        for (Issue o : bulkEditBean.getSelectedIssues()) {
            Issue issue = o;
            if (!this.hasBulkUpdatePermission(bulkEditBean, issue)) {
                return "bulk.edit.unavailable.permission";
            }
            FieldConfig currentConfig = this.getRelevantConfig(issue);
            if (first) {
                if (currentConfig == null) {
                    return "bulk.edit.incompatible.customfields";
                }
                config = currentConfig;
                first = false;
                continue;
            }
            if (!CustomFieldImpl.areDifferent(config, currentConfig)) continue;
            return "bulk.edit.incompatible.customfields";
        }
        if (this.isRenderable()) {
            String rendererType = null;
            Iterator<FieldLayout> i$ = bulkEditBean.getFieldLayouts().iterator();
            while (i$.hasNext()) {
                FieldLayout o;
                FieldLayout fieldLayout = o = i$.next();
                String tempRendererType = fieldLayout.getRendererTypeForField(this.getId());
                if (rendererType == null) {
                    rendererType = tempRendererType;
                    continue;
                }
                if (rendererType.equals(tempRendererType)) continue;
                return "bulk.edit.unavailable.inconsistent.rendertypes";
            }
        }
        return null;
    }

    protected static boolean areDifferent(Object obj1, Object obj2) {
        return obj1 != null && !obj1.equals(obj2) || obj1 == null && obj2 != null;
    }

    protected boolean hasBulkUpdatePermission(BulkEditBean bulkEditBean, Issue issue) {
        return "BulkWorkflowTransition".equals(bulkEditBean.getOperationName()) || this.permissionManager.hasPermission(12, issue, this.authenticationContext.getLoggedInUser());
    }

    @Override
    public String getName() {
        return this.gv.getString("name");
    }

    @Override
    public void setName(String name) {
        this.gv.setString("name", StringUtils.abbreviate((String)name, (int)254));
    }

    @Override
    public String getDescription() {
        return this.gv.getString("description");
    }

    @Override
    public void setDescription(String description) {
        this.gv.setString("description", description);
    }

    @Override
    public CustomFieldSearcher getCustomFieldSearcher() {
        return (CustomFieldSearcher)this.searcherRef.get();
    }

    @Override
    public void setCustomFieldSearcher(CustomFieldSearcher searcher) {
        String key = null;
        if (searcher != null) {
            key = searcher.getDescriptor().getCompleteKey();
        }
        this.gv.setString("customfieldsearcherkey", key);
    }

    @Override
    public CustomFieldType getCustomFieldType() {
        return (CustomFieldType)this.typeRef.get();
    }

    @Override
    public String getColumnHeadingKey() {
        return this.gv.getString("name");
    }

    @Override
    public String getColumnCssClass() {
        return this.getId();
    }

    @Override
    public String getDefaultSortOrder() {
        return "ASC";
    }

    private boolean isSortable() {
        return this.getSortComparatorSource() != null;
    }

    boolean valuesEqual(Object v1, Object v2) {
        return this.getCustomFieldType().valuesEqual(v1, v2);
    }

    @Override
    public int compare(Issue issue1, Issue issue2) throws IllegalArgumentException {
        Object v2;
        if (!this.isSortable()) {
            log.error((Object)"Called compare method, even though not comparable");
            return 0;
        }
        if (issue1 == null && issue2 == null) {
            throw new IllegalArgumentException("issue1 and issue2 are null");
        }
        if (issue1 == null) {
            throw new IllegalArgumentException("issue1 is null");
        }
        if (issue2 == null) {
            throw new IllegalArgumentException("issue2 is null");
        }
        Object v1 = this.getValue(issue1);
        if (v1 == (v2 = this.getValue(issue2))) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof SortableCustomField) {
            SortableCustomField sortable = (SortableCustomField)((Object)customFieldType);
            FieldConfig c1 = this.getRelevantConfig(issue1);
            FieldConfig c2 = this.getRelevantConfig(issue2);
            if (c1 == null || !c1.equals(c2)) {
                log.info((Object)("Sort order for custom field " + this + " for issues " + issue1 + " and " + issue2 + " " + "contexts did not match. Sort order may be incorrect"));
            }
            return sortable.compare(v1, v2, c1);
        }
        return 0;
    }

    @Override
    public LuceneFieldSorter getSorter() {
        if (this.getCustomFieldSearcher() instanceof SortableCustomFieldSearcher) {
            return ((SortableCustomFieldSearcher)((Object)this.getCustomFieldSearcher())).getSorter(this);
        }
        return null;
    }

    @Override
    public FieldComparatorSource getSortComparatorSource() {
        LuceneFieldSorter sorter = this.getSorter();
        if (sorter != null) {
            return new MappedSortComparator(sorter);
        }
        if (this.getCustomFieldType() instanceof SortableCustomField) {
            return new DocumentSortComparatorSource(new DefaultIssueSortComparator(new CustomFieldIssueSortComparator(this)));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field field = (Field)o;
        String id = this.getId();
        String fieldId = field.getId();
        return !(id == null ? fieldId != null : !id.equals(fieldId));
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    @Override
    public GenericValue getGenericValue() {
        return this.gv;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof Field) {
            Field field = (Field)o;
            if (this.getName() == null) {
                if (field.getName() == null) {
                    return 0;
                }
                return -1;
            }
            if (field.getName() == null) {
                return 1;
            }
            return this.getName().compareTo(field.getName());
        }
        throw new IllegalArgumentException("Can only compare Field objects.");
    }

    private boolean rendererTypesEqual(String oldRendererType, String newRendererType) {
        return oldRendererType == null && newRendererType == null || oldRendererType != null && oldRendererType.equals(newRendererType);
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestAwareCustomFieldType) {
            return ((RestAwareCustomFieldType)((Object)customFieldType)).getFieldTypeInfo(fieldTypeInfoContext);
        }
        return new FieldTypeInfo(null, null);
    }

    @Override
    public JsonType getJsonSchema() {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestAwareCustomFieldType) {
            return ((RestAwareCustomFieldType)((Object)customFieldType)).getJsonSchema(this);
        }
        return JsonTypeBuilder.customArray("string", customFieldType.getKey(), this.getIdAsLong());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, FieldLayoutItem fieldLayoutItem) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestAwareCustomFieldType) {
            return ((RestAwareCustomFieldType)((Object)customFieldType)).getJsonFromIssue(this, issue, renderedVersionRequested, fieldLayoutItem);
        }
        Object value = customFieldType.getValueFromIssue(this, issue);
        if (value instanceof Collection) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object v : (Collection)value) {
                list.add(v.toString());
            }
            return new FieldJsonRepresentation(new JsonData(list));
        }
        if (value != null) {
            return new FieldJsonRepresentation(new JsonData(value.toString()));
        }
        return new FieldJsonRepresentation(new JsonData(null));
    }

    @Override
    public RestFieldOperationsHandler getRestFieldOperation() {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestCustomFieldTypeOperations) {
            return ((RestCustomFieldTypeOperations)((Object)customFieldType)).getRestFieldOperation(this);
        }
        return new TextCustomFieldOperationsHandler(this, this.getI18nHelper());
    }

    @Override
    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestCustomFieldTypeOperations) {
            return ((RestCustomFieldTypeOperations)((Object)customFieldType)).getJsonDefaultValue(issueCtx, this);
        }
        FieldConfig config = this.getRelevantConfig(issueCtx);
        Object defaultValue = this.getCustomFieldType().getDefaultValue(config);
        return defaultValue == null ? null : new JsonData(defaultValue);
    }

    class CustomFieldTypeLazyRef
    extends LazyReference<CustomFieldType> {
        CustomFieldTypeLazyRef() {
        }

        protected CustomFieldType create() throws Exception {
            String customFieldKey = CustomFieldImpl.this.gv.getString("customfieldtypekey");
            if (customFieldKey != null) {
                return CustomFieldImpl.this.customFieldManager.getCustomFieldType(customFieldKey);
            }
            return null;
        }
    }

    class CustomFieldSearcherLazyRef
    extends LazyReference<CustomFieldSearcher> {
        CustomFieldSearcherLazyRef() {
        }

        protected CustomFieldSearcher create() throws Exception {
            String customFieldSearcherKey = CustomFieldImpl.this.gv.getString("customfieldsearcherkey");
            CustomFieldSearcher customFieldSearcher = CustomFieldImpl.this.customFieldManager.getCustomFieldSearcher(customFieldSearcherKey);
            if (customFieldSearcher != null) {
                try {
                    customFieldSearcher.init(CustomFieldImpl.this);
                }
                catch (Exception exception) {
                    log.error((Object)String.format("Exception during searcher initialization of the custom field %s:", customFieldSearcherKey), (Throwable)exception);
                    return null;
                }
            }
            return customFieldSearcher;
        }
    }

    static class CustomFieldIssueSortComparator
    implements IssueComparator {
        private final CustomField customField;

        public CustomFieldIssueSortComparator(CustomField customField) {
            if (customField == null) {
                throw new NullPointerException("Custom field cannot be null.");
            }
            this.customField = customField;
        }

        @Override
        public int compare(Issue issue1, Issue issue2) {
            return this.customField.compare(issue1, issue2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomFieldIssueSortComparator that = (CustomFieldIssueSortComparator)o;
            return this.customField.getId().equals(that.customField.getId());
        }

        public int hashCode() {
            return this.customField.getId().hashCode();
        }
    }
}

