/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.ColumnViewDateTimeHelper;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.CreatedDateSearchHandlerFactory;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.statistics.DateFieldSorter;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.velocity.VelocityManager;
import java.sql.Timestamp;
import java.util.Map;

public class CreatedSystemField
extends NavigableFieldImpl
implements SearchableField,
DateField,
RestAwareField {
    private final SearchHandlerFactory searchHandlerFactory;
    private final ColumnViewDateTimeHelper columnViewDateTimeHelper;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public CreatedSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, CreatedDateSearchHandlerFactory searchHandlerFactory, ColumnViewDateTimeHelper columnViewDateTimeHelper, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super("created", "issue.field.created", "issue.column.heading.created", "DESC", velocityManager, applicationProperties, authenticationContext);
        this.searchHandlerFactory = searchHandlerFactory;
        this.columnViewDateTimeHelper = columnViewDateTimeHelper;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    public LuceneFieldSorter getSorter() {
        return DateFieldSorter.ISSUE_CREATED_STATSMAPPER;
    }

    @Override
    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        return this.columnViewDateTimeHelper.render(this, fieldLayoutItem, displayParams, issue, issue.getCreated());
    }

    @Override
    public SearchHandler createAssociatedSearchHandler() {
        return this.searchHandlerFactory.createHandler(this);
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    @Override
    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system("datetime", this.getId());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Timestamp created = issue.getCreated();
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData(Dates.asTimeString(created)));
        if (renderedVersionRequired && created != null) {
            fieldJsonRepresentation.setRenderedData(new JsonData(this.dateTimeFormatterFactory.formatter().forLoggedInUser().format(created)));
        }
        return fieldJsonRepresentation;
    }
}

