/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.VersionJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.fields.util.VersionHelperBean;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.project.VersionProxy;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkMoveHelper;
import com.atlassian.jira.web.bean.DefaultBulkMoveHelper;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public abstract class AbstractVersionsSystemField
extends AbstractOrderableNavigableFieldImpl
implements HideableField,
RequirableField,
RestAwareField {
    private static final Logger log = Logger.getLogger(AbstractVersionsSystemField.class);
    public static final Long UNKNOWN_VERSION_ID = -1L;
    public static final Long UNRELEASED_VERSION_ID = -2L;
    public static final Long RELEASED_VERSION_ID = -3L;
    protected final VersionManager versionManager;
    private final VersionHelperBean versionHelperBean;
    private final JiraBaseUrls jiraBaseUrls;

    public AbstractVersionsSystemField(String id, String name, VelocityManager velocityManager, ApplicationProperties applicationProperties, VersionManager versionManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, VersionHelperBean versionHelperBean, SearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls) {
        super(id, name, velocityManager, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.versionManager = versionManager;
        this.versionHelperBean = versionHelperBean;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @Override
    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put("versions", this.getPossibleVersions(issue.getProject(), this.getUnreleasedVersionsFirst()));
        velocityParams.put("unknownVersionId", UNKNOWN_VERSION_ID);
        velocityParams.put("unreleasedVersionId", UNRELEASED_VERSION_ID);
        velocityParams.put("releasedVersionId", RELEASED_VERSION_ID);
        velocityParams.put("currentVersions", operationContext.getFieldValuesHolder().get(this.getId()));
        if (fieldLayoutItem != null) {
            velocityParams.put("isFrotherControl", HackyRendererType.fromKey(fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
        }
        return this.renderTemplate("versions-edit.vm", velocityParams);
    }

    @Override
    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        GenericValue project = issue.getProject();
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        Collection currentVersions = (Collection)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put("currentVersions", currentVersions);
        velocityParams.put("unknownVersionId", UNKNOWN_VERSION_ID);
        velocityParams.put("unreleasedVersionId", UNRELEASED_VERSION_ID);
        velocityParams.put("releasedVersionId", RELEASED_VERSION_ID);
        velocityParams.put("archivedVersions", this.getArchivedVersionsThatAreSelected(issue, this.getCurrentVersions(issue)));
        velocityParams.put("archivedVersionsTitle", this.getArchivedVersionsFieldTitle());
        velocityParams.put("archivedVersionsSearchParam", this.getArchivedVersionsFieldSearchParam());
        velocityParams.put("project", project);
        velocityParams.put("versions", this.getPossibleVersions(project, this.getUnreleasedVersionsFirst()));
        if (fieldLayoutItem != null) {
            velocityParams.put("isFrotherControl", HackyRendererType.fromKey(fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
        }
        return this.renderTemplate("versions-edit.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Assertions.notNull("bulkEditBean", bulkEditBean);
        Assertions.notEmpty("selectedIssues", bulkEditBean.getSelectedIssues());
        if ("BulkMove".equals(bulkEditBean.getOperationName())) {
            FieldLayoutItem fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem(this);
            DefaultBulkMoveHelper bulkMoveHelper = new DefaultBulkMoveHelper();
            Function<Object, String> versionNameResolver = new Function<Object, String>(){

                @Override
                public String get(Object input) {
                    return AbstractVersionsSystemField.this.versionManager.getVersion((Long)input).getName();
                }
            };
            Function<Issue, Collection<Object>> issueValueResolver = new Function<Issue, Collection<Object>>(){

                @Override
                public Collection<Object> get(Issue input) {
                    LinkedHashMap fieldValuesHolder = new LinkedHashMap();
                    AbstractVersionsSystemField.this.populateFromIssue(fieldValuesHolder, input);
                    return (Collection)fieldValuesHolder.get(AbstractVersionsSystemField.this.getId());
                }
            };
            Map<Long, BulkMoveHelper.DistinctValueResult> distinctVersionValues = bulkMoveHelper.getDistinctValuesForMove(bulkEditBean, this, issueValueResolver, versionNameResolver);
            Issue issue = bulkEditBean.getFirstTargetIssueObject();
            Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
            velocityParams.put("valuesToMap", distinctVersionValues);
            velocityParams.put("bulkMoveHelper", bulkMoveHelper);
            velocityParams.put("unknownVersionId", UNKNOWN_VERSION_ID);
            velocityParams.put("unreleasedVersionId", UNRELEASED_VERSION_ID);
            velocityParams.put("releasedVersionId", RELEASED_VERSION_ID);
            velocityParams.put("versions", this.getPossibleVersions(issue.getProject(), this.getUnreleasedVersionsFirst()));
            if (fieldLayoutItem != null) {
                velocityParams.put("isFrotherControl", HackyRendererType.fromKey(fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
            }
            return this.renderTemplate("versions-bulkmove.vm", velocityParams);
        }
        return super.getBulkEditHtml(operationContext, action, bulkEditBean, displayParameters);
    }

    @Override
    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put("versions", this.getCurrentVersions(issue));
        return this.getViewHtml(velocityParams);
    }

    @Override
    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("versions", value);
        return this.getViewHtml(velocityParams);
    }

    protected Map addViewVelocityParams() {
        return EasyMap.build((Object)"linkToBrowseFixFor", (Object)Boolean.FALSE);
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("versions-view.vm", velocityParams);
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0) {
            LinkedList<Long> versionIds = new LinkedList<Long>();
            for (int i = 0; i < value.length; ++i) {
                versionIds.add(new Long(value[i]));
            }
            return versionIds;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getValueFromParams(Map params) {
        Collection versionIds = (Collection)params.get(this.getId());
        if (versionIds == null || versionIds.contains(UNKNOWN_VERSION_ID)) {
            return Collections.EMPTY_LIST;
        }
        return this.versionManager.getVersions(new LinkedList<Long>(versionIds));
    }

    @Override
    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), this.getVersionIds(issue, stringValue));
    }

    private List getVersionIds(Issue issue, String stringValue) throws FieldValidationException {
        HashSet<Long> versions = new HashSet<Long>();
        if (TextUtils.stringSet((String)stringValue)) {
            String[] versionParams = StringUtils.split((String)stringValue, (String)",");
            for (int i = 0; i < versionParams.length; ++i) {
                String versionParam = versionParams[i];
                try {
                    versions.add(Long.valueOf(versionParam));
                    continue;
                }
                catch (NumberFormatException e) {
                    Version version = this.versionManager.getVersion(issue.getProject().getLong("id"), versionParam);
                    if (version != null) {
                        versions.add(version.getId());
                        continue;
                    }
                    throw new FieldValidationException("Invalid version name '" + versionParam + "'.");
                }
            }
        }
        return new ArrayList(versions);
    }

    @Override
    public void populateFromIssue(Map params, Issue issue) {
        params.put(this.getId(), this.getCurrentVersionIds(issue));
    }

    protected Collection getCurrentVersionIds(Issue issue) {
        LinkedList<Long> currentVersionIds = new LinkedList<Long>();
        for (Version version : this.getCurrentVersions(issue)) {
            currentVersionIds.add(version.getId());
        }
        return currentVersionIds;
    }

    protected abstract Collection getCurrentVersions(Issue var1);

    protected abstract String getArchivedVersionsFieldTitle();

    protected abstract String getArchivedVersionsFieldSearchParam();

    protected abstract boolean getUnreleasedVersionsFirst();

    protected List getPossibleVersions(GenericValue project, boolean unreleasedFirst) {
        ArrayList<VersionProxy> unreleased = new ArrayList<VersionProxy>();
        Iterator<Version> unreleasedIter = this.versionManager.getVersionsUnreleased(project.getLong("id"), false).iterator();
        if (unreleasedIter.hasNext()) {
            unreleased.add(new VersionProxy(UNRELEASED_VERSION_ID.intValue(), this.getAuthenticationContext().getI18nHelper().getText("common.filters.unreleasedversions")));
            while (unreleasedIter.hasNext()) {
                Version version = unreleasedIter.next();
                unreleased.add(new VersionProxy(version));
            }
        }
        ArrayList<VersionProxy> released = new ArrayList<VersionProxy>();
        ArrayList<Version> releasedIter = new ArrayList<Version>(this.versionManager.getVersionsReleased(project.getLong("id"), false));
        if (!releasedIter.isEmpty()) {
            released.add(new VersionProxy(RELEASED_VERSION_ID.intValue(), this.getAuthenticationContext().getI18nHelper().getText("common.filters.releasedversions")));
            Collections.reverse(releasedIter);
            Iterator iterator = releasedIter.iterator();
            while (iterator.hasNext()) {
                released.add(new VersionProxy((Version)iterator.next()));
            }
        }
        ArrayList<VersionProxy> versions = new ArrayList<VersionProxy>();
        if (unreleasedFirst) {
            versions.addAll(unreleased);
            versions.addAll(released);
        } else {
            versions.addAll(released);
            versions.addAll(unreleased);
        }
        return versions;
    }

    @Override
    public void validateParams(OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        Collection versionIds = (Collection)fieldValuesHolder.get(this.getId());
        boolean validIds = this.versionHelperBean.validateVersionIds(versionIds, errorCollection, i18n, this.getId());
        if (fieldScreenRenderLayoutItem.isRequired() && (versionIds == null || versionIds.isEmpty() || versionIds.contains(UNKNOWN_VERSION_ID)) && this.getArchivedVersionsThatAreSelected(issue, this.getCurrentVersions(issue)).isEmpty()) {
            this.addFieldRequiredErrorMessage(issue, errorCollection, i18n);
        }
        if (validIds) {
            this.versionHelperBean.validateVersionForProject(versionIds, issue.getProjectObject(), errorCollection, i18n, this.getId());
        }
    }

    protected abstract void addFieldRequiredErrorMessage(Issue var1, ErrorCollection var2, I18nHelper var3);

    protected abstract String getModifiedWithoutPermissionErrorMessage(I18nHelper var1);

    @Override
    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Collection currentVersions = (Collection)modifiedValue.getOldValue();
        Collection value = this.getUpdatedVersions(issue, (Collection)modifiedValue.getNewValue(), currentVersions);
        if (currentVersions == null || currentVersions.isEmpty()) {
            if (value != null) {
                issueChangeHolder.addChangeItems(this.updateIssueValue(issue, value));
            }
        } else if (!this.valuesEqual(value, currentVersions)) {
            issueChangeHolder.addChangeItems(this.updateIssueValue(issue, value));
        }
    }

    @Override
    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            if (!originalIssue.getProject().equals((Object)targetIssue.getProject())) {
                if (!this.hasValue(originalIssue)) {
                    if (!targetFieldLayoutItem.isRequired()) continue;
                    return new MessagedResult(true);
                }
                return new MessagedResult(true);
            }
            if (!this.getCurrentVersions(originalIssue).isEmpty() || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    @Override
    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        Collection currentVersionNames = this.getVersionNames(this.getCurrentVersions(originalIssue));
        List<Version> possibleVersions = this.getVersionManager().getVersions(targetIssue.getProject());
        LinkedList<Long> versionIds = new LinkedList<Long>();
        for (Version version : possibleVersions) {
            if (!currentVersionNames.contains(version.getName())) continue;
            versionIds.add(version.getId());
        }
        fieldValuesHolder.put(this.getId(), versionIds);
    }

    @Override
    public boolean hasValue(Issue issue) {
        Collection currentVersions = this.getCurrentVersions(issue);
        return currentVersions != null && !currentVersions.isEmpty();
    }

    private Collection getVersionNames(Collection versions) {
        HashSet<String> versionNames = new HashSet<String>();
        for (Version version : versions) {
            versionNames.add(version.getName());
        }
        return versionNames;
    }

    private Collection getUpdatedVersions(Issue issue, Collection selectedVersions, Collection currentVersions) {
        Collection affectedVersionNumbers = this.getArchivedVersionsThatAreSelected(issue, currentVersions);
        if (affectedVersionNumbers != null && !affectedVersionNumbers.isEmpty()) {
            if (selectedVersions == null || selectedVersions.isEmpty()) {
                selectedVersions = new LinkedList();
            }
            selectedVersions.addAll(affectedVersionNumbers);
        }
        return selectedVersions;
    }

    private Collection getArchivedVersionsThatAreSelected(Issue issue, Collection selectedVersions) {
        Collection<Version> archivedVersions = this.versionManager.getVersionsArchived(issue.getProjectObject());
        archivedVersions.retainAll(selectedVersions);
        return archivedVersions;
    }

    private List updateIssueValue(Issue issue, Object value) {
        try {
            LinkedList<GenericValue> versionGVs = new LinkedList<GenericValue>();
            for (Version version : (Collection)value) {
                versionGVs.add(version.getGenericValue());
            }
            return JiraEntityUtils.updateDependentEntities(issue.getGenericValue(), versionGVs, this.getIssueRelationName(), this.getChangeItemFieldName());
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error while saving versions '" + value + "' for issue with id '" + issue.getLong("id") + "'."));
            return null;
        }
    }

    @Override
    public void createValue(Issue issue, Object value) {
        this.updateIssueValue(issue, value);
    }

    @Override
    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), Collections.emptyList());
    }

    @Override
    public Object getDefaultValue(Issue issue) {
        return Collections.EMPTY_LIST;
    }

    protected abstract String getChangeItemFieldName();

    protected abstract String getIssueRelationName();

    protected VersionManager getVersionManager() {
        return this.versionManager;
    }

    @Override
    public String getDefaultSortOrder() {
        return "ASC";
    }

    @Override
    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("versions", this.getCurrentVersions(issue));
        velocityParams.putAll(this.addViewVelocityParams());
        return this.renderTemplate("versions-columnview.vm", velocityParams);
    }

    @Override
    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (!bulkEditBean.isMultipleProjects() && bulkEditBean.getProject() != null) {
            if (this.getVersionManager().getVersions(bulkEditBean.getProject()).isEmpty()) {
                return "bulk.edit.unavailable.noversions";
            }
            for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
                if (!fieldLayout.isFieldHidden(this.getId())) continue;
                return "bulk.edit.unavailable.hidden";
            }
            for (Issue issue : bulkEditBean.getSelectedIssues()) {
                if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
                return "bulk.edit.unavailable.permission";
            }
            return null;
        }
        return "bulk.edit.unavailable.multipleprojects";
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        List<Version> versions = this.versionManager.getVersions(fieldTypeInfoContext.getIssueContext().getProjectObject().getId());
        return new FieldTypeInfo(versions, null);
    }

    @Override
    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray("version", this.getId());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Collection versions = this.getCurrentVersions(issue);
        Collection<VersionJsonBean> beans = VersionJsonBean.shortBeans(versions, this.jiraBaseUrls);
        return new FieldJsonRepresentation(new JsonData(beans));
    }
}

