/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.ProgressJsonBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.TimeTrackingGraphBean;
import com.atlassian.velocity.VelocityManager;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public abstract class AbstractProgressBarSystemField
extends NavigableFieldImpl
implements RestAwareField {
    private static final Logger log = Logger.getLogger(AbstractProgressBarSystemField.class);

    public AbstractProgressBarSystemField(String id, String nameKey, String columnHeadingKey, VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        super(id, nameKey, columnHeadingKey, "ASC", velocityManager, applicationProperties, authenticationContext);
    }

    @Override
    public String getHiddenFieldId() {
        return "timetracking";
    }

    @Override
    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Long percentage;
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        I18nHelper i18nBean = this.authenticationContext.getI18nHelper();
        TimeTrackingParameters params = this.getTimeTrackingGraphBeanParameters(issue, i18nBean);
        Long spent = params.getSpent();
        Long originalEstimate = params.getOriginalEstimate();
        Long remainingEstimate = params.getRemainingEstimate();
        AggregateTimeTrackingBean aggregateTTBean = (AggregateTimeTrackingBean)displayParams.get("aggTTBean");
        if (aggregateTTBean == null) {
            velocityParams.put("innerGraphWidth", "100%");
        } else {
            velocityParams.put("innerGraphWidth", "100%");
            Long greatestEstimate = aggregateTTBean.getGreastestSubTaskEstimate();
            Long subTaskEstimate = AggregateTimeTrackingBean.getTheGreaterOfEstimates(originalEstimate, remainingEstimate, spent);
            if (greatestEstimate != null && subTaskEstimate != null && greatestEstimate > 0L) {
                int width = (int)((float)subTaskEstimate.longValue() / (float)greatestEstimate.longValue() * 100.0f);
                velocityParams.put("innerGraphWidth", width + "%");
            }
        }
        try {
            percentage = AbstractProgressBarSystemField.calculateProgressPercentage(spent, remainingEstimate);
        }
        catch (IllegalArgumentException probablyNegative) {
            percentage = 0L;
            log.error((Object)("Issue: '" + issue.getKey() + "' has an uncalculable percentage"), (Throwable)probablyNegative);
        }
        velocityParams.put("percentComplete", this.decorateProgressPercentage(percentage));
        velocityParams.put("graphBean", params.getTimeTrackingGraphBean());
        velocityParams.put("graphDisplayId", this.getDisplayId());
        return this.renderTemplate("progress-bar.vm", velocityParams);
    }

    public static Long calculateProgressPercentage(Long spent, Long remainingEstimate) {
        if (spent != null && remainingEstimate != null) {
            if (0L > spent) {
                throw new IllegalArgumentException("Time spent must be a non-negative number: '" + spent + "'");
            }
            if (0L > remainingEstimate) {
                throw new IllegalArgumentException("Remaining estimate must be a non-negative number: '" + remainingEstimate + "'");
            }
            if (spent == 0L && remainingEstimate == 0L) {
                return null;
            }
            return (long)((float)spent.longValue() / (float)(spent + remainingEstimate) * 100.0f);
        }
        if (spent != null) {
            return 100L;
        }
        if (remainingEstimate != null) {
            return 0L;
        }
        return null;
    }

    private String decorateProgressPercentage(Number percentage) {
        return percentage == null ? "" : percentage.toString() + "%";
    }

    protected abstract TimeTrackingParameters getTimeTrackingGraphBeanParameters(Issue var1, I18nHelper var2);

    protected abstract String getDisplayId();

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    @Override
    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system("progress", this.getId());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        TimeTrackingParameters ttParams = this.getTimeTrackingGraphBeanParameters(issue, this.authenticationContext.getI18nHelper());
        long spent = ttParams.getSpent() == null ? 0L : ttParams.getSpent();
        long remainingEstimate = ttParams.getRemainingEstimate() == null ? 0L : ttParams.getRemainingEstimate();
        Long percentage = AbstractProgressBarSystemField.calculateProgressPercentage(spent, remainingEstimate);
        long total = spent + remainingEstimate;
        return new FieldJsonRepresentation(new JsonData(ProgressJsonBean.shortBean(spent, total, percentage)));
    }

    protected static class TimeTrackingParameters {
        private final Long spent;
        private final Long originalEstimate;
        private final Long remainingEstimate;
        private final TimeTrackingGraphBean timeTrackingGraphBean;

        public TimeTrackingParameters(Long spent, Long originalEstimate, Long remainingEstimate, TimeTrackingGraphBean timeTrackingGraphBean) {
            this.spent = spent;
            this.originalEstimate = originalEstimate;
            this.remainingEstimate = remainingEstimate;
            this.timeTrackingGraphBean = timeTrackingGraphBean;
        }

        public Long getSpent() {
            return this.spent;
        }

        public Long getOriginalEstimate() {
            return this.originalEstimate;
        }

        public Long getRemainingEstimate() {
            return this.remainingEstimate;
        }

        public TimeTrackingGraphBean getTimeTrackingGraphBean() {
            return this.timeTrackingGraphBean;
        }
    }
}

