/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.security.JiraAuthenticationContext;

public class AbstractField
implements Field {
    private String id;
    private String name;
    protected final JiraAuthenticationContext authenticationContext;

    public AbstractField(String id, String name, JiraAuthenticationContext authenticationContext) {
        this.id = id;
        this.name = name;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNameKey() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.authenticationContext.getI18nHelper().getText(this.getNameKey());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field field = (Field)o;
        return !(this.id != null ? !this.id.equals(field.getId()) : field.getId() != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    protected JiraAuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof Field) {
            Field field = (Field)o;
            if (this.getName() == null) {
                if (field.getName() == null) {
                    return 0;
                }
                return -1;
            }
            if (field.getName() == null) {
                return 1;
            }
            return this.getName().compareTo(field.getName());
        }
        throw new IllegalArgumentException("Can only compare Field objects.");
    }
}

