/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AbstractDurationSystemField;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.velocity.VelocityManager;
import java.util.Comparator;
import java.util.Map;

public abstract class AbstractAggregateDurationSystemField
extends AbstractDurationSystemField {
    protected final AggregateTimeTrackingCalculatorFactory calculatorFactory;

    public AbstractAggregateDurationSystemField(String id, String nameKey, String columnHeadingKey, String defaultSortOrder, Comparator comparator, VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, AggregateTimeTrackingCalculatorFactory calculatorFactory) {
        super(id, nameKey, columnHeadingKey, defaultSortOrder, comparator, velocityManager, applicationProperties, authenticationContext);
        this.calculatorFactory = calculatorFactory;
    }

    @Override
    public LuceneFieldSorter getSorter() {
        return null;
    }

    @Override
    protected Long getDuration(Issue issue) {
        return this.getAggregateDuration(this.getAggregateBean(issue));
    }

    private AggregateTimeTrackingBean getAggregateBean(Issue issue) {
        String cacheKey;
        Map<String, Object> requestCache = JiraAuthenticationContextImpl.getRequestCache();
        AggregateTimeTrackingBean bean = (AggregateTimeTrackingBean)requestCache.get(cacheKey = "jira.timetracking.aggregate.bean." + issue.getKey());
        if (bean == null) {
            bean = this.calculatorFactory.getCalculator(issue).getAggregates(issue);
            requestCache.put(cacheKey, bean);
        }
        return bean;
    }

    protected abstract Long getAggregateDuration(AggregateTimeTrackingBean var1);
}

