/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.GroupNameComparator;
import com.atlassian.query.operator.Operator;
import com.atlassian.util.concurrent.Assertions;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class GroupPickerStatisticsMapper
implements StatisticsMapper<Group> {
    private final CustomField customField;
    private final ClauseNames clauseNames;
    private JiraAuthenticationContext authenticationContext;
    private CustomFieldInputHelper customFieldInputHelper;
    private GroupManager groupManager;

    public GroupPickerStatisticsMapper(CustomField customField, GroupManager groupManager, JiraAuthenticationContext authenticationContext, CustomFieldInputHelper customFieldInputHelper) {
        this.groupManager = groupManager;
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        this.customFieldInputHelper = (CustomFieldInputHelper)Assertions.notNull((String)"customFieldInputHelper", (Object)customFieldInputHelper);
        this.customField = (CustomField)Assertions.notNull((String)"customField", (Object)customField);
        this.clauseNames = customField.getClauseNames();
    }

    @Override
    public String getDocumentConstant() {
        return this.customField.getId();
    }

    @Override
    public Group getValueFromLuceneField(String documentValue) {
        if (StringUtils.isBlank((String)documentValue)) {
            return null;
        }
        return this.groupManager.getGroup(documentValue);
    }

    @Override
    public Comparator<Group> getComparator() {
        return new GroupNameComparator();
    }

    protected String getSearchValue(Object value) {
        Group group = (Group)value;
        return group.getName();
    }

    @Override
    public boolean isValidValue(Group value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return false;
    }

    @Override
    public SearchRequest getSearchUrlSuffix(Group value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        String clauseName = this.customFieldInputHelper.getUniqueClauseName(this.authenticationContext.getLoggedInUser(), this.clauseNames.getPrimaryName(), this.customField.getName());
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder(searchRequest.getQuery()).where().defaultAnd();
        if (value != null) {
            builder.addStringCondition(clauseName, Operator.EQUALS, value.getName());
        } else {
            builder.addEmptyCondition(clauseName);
        }
        return new SearchRequest(builder.buildQuery());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupPickerStatisticsMapper that = (GroupPickerStatisticsMapper)o;
        if (!this.clauseNames.equals(that.clauseNames)) {
            return false;
        }
        return this.customField.getId().equals(that.customField.getId());
    }

    @Override
    public int hashCode() {
        int result = this.customField.getId().hashCode();
        result = 31 * result + this.clauseNames.hashCode();
        return result;
    }
}

