/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractUserSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserPickerGroupCustomFieldRenderer
extends AbstractUserSearchRenderer
implements SearchRenderer {
    private static final String KEY_VALUE = "value";
    private static final String KEY_KEY = "key";
    private static final String KEY_RELATED = "related";
    private final CustomField field;
    private final FieldVisibilityManager fieldVisibilityManager;

    public UserPickerGroupCustomFieldRenderer(CustomField field, UserFieldSearchConstants searchConstants, String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, UserPickerSearchService searchService, FieldVisibilityManager fieldVisibilityManager) {
        super(searchConstants, nameKey, velocityRequestContextFactory, applicationProperties, velocityManager, searchService);
        this.field = field;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    public boolean isShown(User searcher, SearchContext searchContext) {
        return CustomFieldUtils.isShownAndVisible(this.getCustomField(), searcher, searchContext, this.fieldVisibilityManager);
    }

    @Override
    protected List<Map<String, String>> getSelectedListOptions(User searcher) {
        ArrayList<Map<String, String>> types = new ArrayList<Map<String, String>>();
        I18nBean i18n = new I18nBean(searcher);
        types.add(MapBuilder.newBuilder().add(KEY_VALUE, i18n.getText("assignee.types.anyuser")).add(KEY_KEY, null).add(KEY_RELATED, "select.list.none").toHashMap());
        if (searcher != null) {
            types.add(MapBuilder.newBuilder().add(KEY_VALUE, i18n.getText("assignee.types.currentuser")).add(KEY_KEY, "issue_current_user").add(KEY_RELATED, "select.list.none").toHashMap());
        }
        types.add(MapBuilder.newBuilder().add(KEY_VALUE, i18n.getText("assignee.types.specifyuser")).add(KEY_KEY, "specificuser").add(KEY_RELATED, "select.list.user").toHashMap());
        types.add(MapBuilder.newBuilder().add(KEY_VALUE, i18n.getText("assignee.types.specifygroup")).add(KEY_KEY, "specificgroup").add(KEY_RELATED, "select.list.group").toHashMap());
        return types;
    }

    @Override
    protected String getEmptyValueKey() {
        return "should_never_be_selected";
    }

    private CustomField getCustomField() {
        return this.field;
    }
}

