/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.converters.GroupConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.GroupCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.customfields.statistics.GroupPickerStatisticsMapper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.GroupCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ActualValueCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.util.GroupCustomFieldIndexValueConverter;
import com.atlassian.jira.jql.validator.GroupCustomFieldValidator;
import com.atlassian.jira.jql.values.GroupValuesGenerator;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class GroupPickerSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private volatile ClauseNames clauseNames;
    private final GroupConverter groupConverter;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private GroupManager groupManager;
    private final GroupValuesGenerator groupValuesGenerator;
    private final CustomFieldInputHelper customFieldInputHelper;

    public GroupPickerSearcher(GroupConverter groupConverter, FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, GroupManager groupManager, GroupValuesGenerator groupValuesGenerator, CustomFieldInputHelper customFieldInputHelper) {
        this.groupConverter = groupConverter;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.groupManager = groupManager;
        this.groupValuesGenerator = groupValuesGenerator;
        this.customFieldInputHelper = Assertions.notNull("customFieldInputHelper", customFieldInputHelper);
    }

    @Override
    public void init(CustomField field) {
        this.clauseNames = field.getClauseNames();
        GroupCustomFieldIndexer indexer = new GroupCustomFieldIndexer(this.fieldVisibilityManager, field, this.groupConverter);
        GroupCustomFieldIndexValueConverter fieldIndexValueConverter = new GroupCustomFieldIndexValueConverter(this.groupConverter);
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(this.clauseNames, this.getDescriptor(), field, customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new GroupCustomFieldSearchInputTransformer(field, this.clauseNames, this.searcherInformation.getId(), this.groupConverter, this.customFieldInputHelper);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldValueGeneratingClauseHandler(new GroupCustomFieldValidator(this.jqlOperandResolver, fieldIndexValueConverter), new ActualValueCustomFieldClauseQueryFactory(field.getId(), this.jqlOperandResolver, fieldIndexValueConverter, false), this.groupValuesGenerator, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.GROUP);
    }

    @Override
    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    @Override
    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    @Override
    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new GroupPickerStatisticsMapper(customField, this.groupManager, ComponentAccessor.getJiraAuthenticationContext(), this.customFieldInputHelper);
    }

    @Override
    public LuceneFieldSorter getSorter(CustomField customField) {
        return new GroupPickerStatisticsMapper(customField, this.groupManager, ComponentAccessor.getJiraAuthenticationContext(), this.customFieldInputHelper);
    }
}

