/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.CustomFieldLabelsIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.CustomFieldLabelsSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.CustomFieldLabelsStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.LabelsClauseQueryFactory;
import com.atlassian.jira.jql.validator.LabelsValidator;
import com.atlassian.jira.jql.values.LabelsClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CustomFieldLabelsSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
CustomFieldStattable {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final LabelsClauseValuesGenerator labelsClauseValuesGenerator;
    private final JiraAuthenticationContext authenticationContext;
    private final CustomFieldInputHelper customFieldInputHelper;
    private CustomFieldSearcherInformation searcherInformation;
    private SearchRenderer searchRenderer;
    private SearchInputTransformer searchInputTransformer;
    private CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;

    public CustomFieldLabelsSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, LabelsClauseValuesGenerator labelsClauseValuesGenerator, JiraAuthenticationContext authenticationContext, CustomFieldInputHelper customFieldInputHelper) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.labelsClauseValuesGenerator = labelsClauseValuesGenerator;
        this.authenticationContext = authenticationContext;
        this.customFieldInputHelper = customFieldInputHelper;
    }

    @Override
    public void init(CustomField customField) {
        ClauseNames names = customField.getClauseNames();
        CustomFieldLabelsIndexer fieldIndexer = new CustomFieldLabelsIndexer(this.fieldVisibilityManager, customField);
        LabelCustomFieldValueProvider customFieldValueProvider = new LabelCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(customField.getId(), customField.getNameKey(), Arrays.asList(fieldIndexer), new AtomicReference<CustomField>(customField));
        this.searchRenderer = new CustomFieldRenderer(names, this.getDescriptor(), customField, customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new CustomFieldLabelsSearchInputTransformer(customField, customField.getId(), this.customFieldInputHelper, names);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldValueGeneratingClauseHandler(new LabelsValidator(this.jqlOperandResolver), new LabelsClauseQueryFactory(this.jqlOperandResolver, customField.getId() + "_folded"), this.labelsClauseValuesGenerator, SystemSearchConstants.forLabels().getSupportedOperators(), SystemSearchConstants.forLabels().getDataType());
    }

    @Override
    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        return this.customFieldSearcherClauseHandler;
    }

    @Override
    public SearcherInformation<CustomField> getSearchInformation() {
        return this.searcherInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }

    @Override
    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new CustomFieldLabelsStatisticsMapper(customField, this.customFieldInputHelper, this.authenticationContext, false);
    }

    static class LabelCustomFieldValueProvider
    implements CustomFieldValueProvider {
        LabelCustomFieldValueProvider() {
        }

        @Override
        public Object getStringValue(CustomField customField, FieldValuesHolder fieldValuesHolder) {
            Collection allValues;
            StringBuilder resultBuilder = new StringBuilder();
            CustomFieldParams customFieldParams = customField.getCustomFieldValues(fieldValuesHolder);
            if (customFieldParams != null && (allValues = customFieldParams.getAllValues()) != null) {
                for (String label : allValues) {
                    resultBuilder.append(StringEscapeUtils.escapeHtml((String)label)).append(" ");
                }
            }
            return StringUtils.trim((String)resultBuilder.toString());
        }

        @Override
        public Object getValue(CustomField customField, FieldValuesHolder fieldValuesHolder) {
            CustomFieldParams customFieldParams = customField.getCustomFieldValues(fieldValuesHolder);
            return customField.getCustomFieldType().getValueFromCustomFieldParams(customFieldParams);
        }
    }
}

