/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.issue.search.QueryContextConverter;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.DefaultCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldClauseContextHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CascadingSelectCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.CascadingSelectCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.context.CascadingSelectCustomFieldClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.CascadingSelectCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.ValidatingDecoratorQueryFactory;
import com.atlassian.jira.jql.util.JqlCascadingSelectLiteralUtil;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.jql.validator.CascadingSelectCustomFieldValidator;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.FieldVisibilityBean;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class CascadingSelectSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher {
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private final ComponentLocator componentLocator;
    private final ComponentFactory componentFactory;

    public CascadingSelectSearcher(ComponentLocator componentLocator, ComponentFactory componentFactory) {
        this.componentLocator = Assertions.notNull("componentLocator", componentLocator);
        this.componentFactory = Assertions.notNull("componentFactory", componentFactory);
    }

    @Override
    public void init(CustomField field) {
        FieldVisibilityManager fieldVisibilityManager = this.componentLocator.getComponentInstanceOfType(FieldVisibilityBean.class);
        SelectConverter selectConverter = this.componentLocator.getComponentInstanceOfType(SelectConverter.class);
        JqlOperandResolver jqlOperandResolver = this.componentLocator.getComponentInstanceOfType(JqlOperandResolver.class);
        JqlSelectOptionsUtil jqlSelectOptionsUtil = this.componentLocator.getComponentInstanceOfType(JqlSelectOptionsUtil.class);
        JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil = this.componentLocator.getComponentInstanceOfType(JqlCascadingSelectLiteralUtil.class);
        QueryContextConverter queryContextConverter = this.componentLocator.getComponentInstanceOfType(QueryContextConverter.class);
        CustomFieldInputHelper customFieldInputHelper = this.componentLocator.getComponentInstanceOfType(CustomFieldInputHelper.class);
        OperatorUsageValidator usageValidator = this.componentLocator.getComponentInstanceOfType(OperatorUsageValidator.class);
        ClauseNames names = field.getClauseNames();
        CascadingSelectCustomFieldIndexer indexer = new CascadingSelectCustomFieldIndexer(fieldVisibilityManager, field);
        DefaultCustomFieldValueProvider customFieldValueProvider = new DefaultCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(names, this.getDescriptor(), field, customFieldValueProvider, fieldVisibilityManager);
        this.searchInputTransformer = new CascadingSelectCustomFieldSearchInputTransformer(names, field, this.searcherInformation.getId(), selectConverter, jqlOperandResolver, jqlSelectOptionsUtil, jqlCascadingSelectLiteralUtil, queryContextConverter, customFieldInputHelper);
        ClauseQueryFactory queryFactory = new CascadingSelectCustomFieldClauseQueryFactory(field, field.getId(), jqlSelectOptionsUtil, jqlOperandResolver, jqlCascadingSelectLiteralUtil);
        queryFactory = new ValidatingDecoratorQueryFactory(usageValidator, queryFactory);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldClauseContextHandler(this.componentFactory.createObject(CascadingSelectCustomFieldValidator.class, field), queryFactory, this.componentFactory.createObject(CascadingSelectCustomFieldClauseContextFactory.class, field), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.CASCADING_OPTION);
    }

    @Override
    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    @Override
    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }
}

