/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.option;

import com.atlassian.jira.issue.comparator.BeanComparatorIgnoreCase;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.CollectionReorderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;

public class OptionsImpl
extends ArrayList<Option>
implements Options {
    static final long serialVersionUID = 1946632069203605222L;
    private Map<Long, Option> optionsLookup;
    private final FieldConfig relatedField;
    private final CollectionReorderer<Option> reorderer;
    private final OptionsManager optionsManager;

    public OptionsImpl(List<Option> options, FieldConfig relatedField, CollectionReorderer<Option> reorderer, OptionsManager optionsManager) {
        this.relatedField = relatedField;
        this.reorderer = reorderer;
        this.optionsManager = optionsManager;
        this.optionsLookup = new HashMap<Long, Option>();
        this.populateFromOptions(options, relatedField);
    }

    private void populateFromOptions(List options, FieldConfig relatedField) {
        MultiHashMap parentChildMap = new MultiHashMap();
        if (options != null && !options.isEmpty()) {
            for (Object option1 : options) {
                Option option = (Option)option1;
                Option parentOption = option.getParentOption();
                parentChildMap.put(parentOption != null ? parentOption.getOptionId() : null, option);
                this.optionsLookup.put(option.getOptionId(), option);
            }
            Collection rootOptions = (Collection)parentChildMap.get(null);
            this.addAll(rootOptions);
        }
    }

    @Override
    public List<Option> getRootOptions() {
        return this;
    }

    private Collection<Option> getPeerOptions(Option option) {
        Option parentOption = option.getParentOption();
        if (parentOption != null) {
            return parentOption.getChildOptions();
        }
        return this.getRootOptions();
    }

    @Override
    public Option getOptionForValue(String value, Long parentOptionId) {
        List<Option> optionsForParent = parentOptionId != null ? this.getOptionById(parentOptionId).getChildOptions() : this.getRootOptions();
        if (optionsForParent != null) {
            for (Option option : optionsForParent) {
                if (option == null || option.getValue() == null || !option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
        }
        return null;
    }

    @Override
    public void setValue(Option option, String value) {
        this.optionsManager.setValue(option, value);
    }

    @Override
    public Option addOption(Option parent, String value) {
        Long parentOptionId;
        List<Option> parentColl;
        if (parent != null) {
            parentColl = parent.getChildOptions();
            parentOptionId = parent.getOptionId();
        } else {
            parentColl = this.getRootOptions();
            parentOptionId = null;
        }
        Long lastPosition = new Long(parentColl != null ? (long)parentColl.size() : 0L);
        return this.optionsManager.createOption(this.getRelatedFieldConfig(), parentOptionId, lastPosition, value);
    }

    @Override
    public void removeOption(Option option) {
        this.optionsManager.deleteOptionAndChildren(option);
        Collection<Option> peers = this.getPeerOptions(option);
        int i = 0;
        Iterator<Option> iterator = peers.iterator();
        while (iterator.hasNext()) {
            Option currentOption = iterator.next();
            if (currentOption.equals(option)) {
                iterator.remove();
                continue;
            }
            currentOption.setSequence(Long.valueOf(i));
            ++i;
        }
        this.optionsManager.updateOptions(peers);
    }

    @Override
    public void sortOptionsByValue(Option parentOption) {
        ArrayList<Option> options = new ArrayList<Option>(parentOption != null ? parentOption.getChildOptions() : this.getRootOptions());
        Collections.sort(options, new BeanComparatorIgnoreCase("value"));
        this.renumberOptions(options);
        this.optionsManager.updateOptions(options);
    }

    @Override
    public void moveOptionToPosition(Map<Integer, Option> positionsToOptions) {
        if (positionsToOptions.isEmpty()) {
            return;
        }
        Option option = positionsToOptions.values().iterator().next();
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        this.reorderer.moveToPosition(peerOptions, positionsToOptions);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    @Override
    public void moveToStartSequence(Option option) {
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        this.reorderer.moveToStart(peerOptions, option);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    @Override
    public void incrementSequence(Option option) {
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        this.reorderer.decreasePosition(peerOptions, option);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    @Override
    public void decrementSequence(Option option) {
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        this.reorderer.increasePosition(peerOptions, option);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    @Override
    public void moveToLastSequence(Option option) {
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        this.reorderer.moveToEnd(peerOptions, option);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    @Override
    public void disableOption(Option option) {
        this.optionsManager.disableOption(option);
    }

    @Override
    public void enableOption(Option option) {
        this.optionsManager.enableOption(option);
    }

    @Override
    public Option getOptionById(Long optionId) {
        return this.optionsLookup.get(optionId);
    }

    @Override
    public FieldConfig getRelatedFieldConfig() {
        return this.relatedField;
    }

    private void renumberOptions(List options) {
        if (options != null) {
            for (int i = 0; i < options.size(); ++i) {
                Option option = (Option)options.get(i);
                option.setSequence(Long.valueOf(i));
            }
        }
    }
}

