/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.option;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.util.concurrent.LazyReference;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class LazyLoadedOption
implements Option,
Comparable<Option> {
    private final GenericValue gv;
    private final OptionsManager optionsManager;
    private final FieldConfigManager fieldManager;
    private final LazyReference<FieldConfig> relatedField = new LazyReference<FieldConfig>(){

        protected FieldConfig create() throws Exception {
            return LazyLoadedOption.this.fieldManager.getFieldConfig(LazyLoadedOption.this.gv.getLong("customfieldconfig"));
        }
    };
    private final LazyReference<Option> parentOption = new LazyReference<Option>(){

        protected Option create() throws Exception {
            return LazyLoadedOption.this.optionsManager.findByOptionId(LazyLoadedOption.this.gv.getLong("parentoptionid"));
        }
    };
    private final LazyReference<List<Option>> childOptions = new LazyReference<List<Option>>(){

        protected List<Option> create() {
            return LazyLoadedOption.this.optionsManager.findByParentId(LazyLoadedOption.this.getOptionId());
        }
    };

    public LazyLoadedOption(GenericValue gv, OptionsManager optionsManager, FieldConfigManager fieldManager) {
        this.gv = gv;
        this.fieldManager = fieldManager;
        this.optionsManager = optionsManager;
    }

    @Override
    public FieldConfig getRelatedCustomField() {
        return (FieldConfig)this.relatedField.get();
    }

    @Override
    public Option getParentOption() {
        return (Option)this.parentOption.get();
    }

    @Override
    public List<Option> getChildOptions() {
        return (List)this.childOptions.get();
    }

    @Override
    public List<Option> retrieveAllChildren(@Nullable List<Option> listToAddTo) {
        List<Option> children;
        if (listToAddTo == null) {
            listToAddTo = new LinkedList<Option>();
        }
        if ((children = this.getChildOptions()) != null) {
            for (Option childOption : children) {
                listToAddTo.add(childOption);
                childOption.retrieveAllChildren(listToAddTo);
            }
        }
        return listToAddTo;
    }

    @Override
    public Long getOptionId() {
        return this.gv.getLong("id");
    }

    @Override
    public Long getSequence() {
        return this.gv.getLong("sequence");
    }

    @Override
    public String getValue() {
        return this.gv.getString("value");
    }

    @Override
    public Boolean getDisabled() {
        Boolean disabled = this.gv.getBoolean("disabled");
        return disabled != null ? disabled : false;
    }

    @Override
    public void setValue(String value) {
        this.gv.set("value", (Object)value);
    }

    @Override
    public void setSequence(Long sequence) {
        this.gv.set("sequence", (Object)sequence);
    }

    @Override
    public void setDisabled(Boolean disabled) {
        this.gv.set("disabled", (Object)disabled);
    }

    @Override
    public void store() {
        try {
            this.gv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e.getMessage(), e);
        }
    }

    @Override
    public GenericValue getGenericValue() {
        return this.gv;
    }

    @Override
    public int compareTo(Option o) {
        return new CompareToBuilder().append((Object)this.getSequence(), (Object)o.getSequence()).append((Object)this.getOptionId(), (Object)o.getOptionId()).toComparison();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Option)) {
            return false;
        }
        Option rhs = (Option)o;
        return new EqualsBuilder().append((Object)this.getOptionId(), (Object)rhs.getOptionId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(147, 17).append((Object)this.getOptionId()).toHashCode();
    }

    public String toString() {
        return this.getValue();
    }
}

