/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.customfields.manager.DefaultOptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.CollectionReorderer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class CachedOptionsManager
extends DefaultOptionsManager
implements Startable {
    private final ConcurrentMap<Long, Options> optionsCache = new ConcurrentHashMap<Long, Options>();
    private final ConcurrentMap<Long, Option> optionCache = new ConcurrentHashMap<Long, Option>();
    private final ConcurrentMap parentcache = new ConcurrentHashMap();
    private final ConcurrentMap<String, List<Option>> valueCache = new ConcurrentHashMap<String, List<Option>>();
    private final AtomicReference<List<Option>> allCache = new AtomicReference<Object>(null);
    private final EventPublisher eventPublisher;

    public CachedOptionsManager(OfBizDelegator delegator, CollectionReorderer reorderer, FieldConfigManager fieldConfigManager, EventPublisher eventPublisher) {
        super(delegator, reorderer, fieldConfigManager);
        this.eventPublisher = eventPublisher;
        this.init();
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.init();
    }

    private synchronized void init() {
        this.optionsCache.clear();
        this.parentcache.clear();
        this.optionCache.clear();
        this.valueCache.clear();
        this.allCache.set(null);
    }

    @Override
    public List<Option> getAllOptions() {
        List<Option> allOptions = this.allCache.get();
        if (allOptions == null) {
            allOptions = super.getAllOptions();
            this.allCache.compareAndSet(null, allOptions);
        }
        return allOptions;
    }

    @Override
    public List<Option> findByOptionValue(String value) {
        if (value == null) {
            return null;
        }
        List<Option> options = (List<Option>)this.valueCache.get(value = CaseFolding.foldString(value));
        if (options != null) {
            return options;
        }
        options = super.findByOptionValue(value);
        if (options != null) {
            this.valueCache.put(value, options);
        }
        return options;
    }

    @Override
    public Options getOptions(FieldConfig fieldConfig) {
        Long key;
        Long l = key = fieldConfig == null ? null : fieldConfig.getId();
        if (key == null) {
            return super.getOptions(fieldConfig);
        }
        Options value = (Options)this.optionsCache.get(key);
        if (value != null) {
            return value;
        }
        Options options = super.getOptions(fieldConfig);
        if (options != null) {
            Options result = this.optionsCache.putIfAbsent(key, options);
            return result == null ? options : result;
        }
        return options;
    }

    @Override
    public void setRootOptions(FieldConfig fieldConfig, Options options) {
        super.setRootOptions(fieldConfig, options);
        this.init();
    }

    @Override
    public void removeCustomFieldOptions(CustomField customField) {
        super.removeCustomFieldOptions(customField);
        this.init();
    }

    @Override
    public void removeCustomFieldConfigOptions(FieldConfig fieldConfig) {
        super.removeCustomFieldConfigOptions(fieldConfig);
        this.init();
    }

    public void updateOptions(Collection options) {
        super.updateOptions(options);
        this.init();
    }

    @Override
    public Option createOption(FieldConfig fieldConfig, Long parentOptionId, Long sequence, String value) {
        Option option = super.createOption(fieldConfig, parentOptionId, sequence, value);
        this.init();
        return option;
    }

    @Override
    public void deleteOptionAndChildren(Option option) {
        super.deleteOptionAndChildren(option);
        this.init();
    }

    @Override
    public void setValue(Option option, String value) {
        super.setValue(option, value);
        this.init();
    }

    @Override
    public void disableOption(Option option) {
        super.disableOption(option);
        this.init();
    }

    @Override
    public void enableOption(Option option) {
        super.enableOption(option);
        this.init();
    }

    @Override
    public Option findByOptionId(Long optionId) {
        if (optionId == null) {
            return null;
        }
        Option value = (Option)this.optionCache.get(optionId);
        if (value != null) {
            return value;
        }
        Option option = super.findByOptionId(optionId);
        if (option != null) {
            Option result = this.optionCache.putIfAbsent(optionId, option);
            return result == null ? option : result;
        }
        return option;
    }

    public List findByParentId(Long parentOptionId) {
        if (parentOptionId == null) {
            return null;
        }
        List value = (List)this.parentcache.get(parentOptionId);
        if (value != null) {
            return value;
        }
        List<Option> options = super.findByParentId(parentOptionId);
        if (options != null) {
            this.parentcache.put(parentOptionId, options);
        }
        return options;
    }
}

